/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.util.Locale;
import java.util.Map;
import java.util.jar.JarFile;
import org.diet4j.core.AbstractModuleRegistry;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleLicense;
import org.diet4j.core.ModuleRequirement;

public class ModuleMeta {
    protected String theModuleGroupId;
    protected String theModuleArtifactId;
    protected String theModuleVersion;
    protected long theModuleBuildDate;
    protected Map<String, String> theModuleUserNames;
    protected Map<String, String> theModuleUserDescriptions;
    protected ModuleRequirement[] theRuntimeModuleRequirements;
    protected ModuleLicense theModuleLicense;
    protected JarFile theModuleJar;
    protected String theResourceJarEntryPrefix;
    public static final String JAR_RESOURCE_JAR_ENTRY_PREFIX = "";
    public static final String WAR_RESOURCE_JAR_ENTRY_PREFIX = "WEB-INF/classes/";
    public static final String UNPACKED_RESOURCE_JAR_ENTRY_PREFIX = "";
    protected String theActivationClassName;
    protected String theRunClassName;

    protected ModuleMeta(String moduleGroupId, String moduleArtifactId, String moduleVersion, Map<String, String> moduleUserNames, Map<String, String> moduleUserDescriptions, long moduleBuildDate, ModuleLicense license, ModuleRequirement[] runtimeModuleRequirements, JarFile moduleJar, String activationClassName, String runClassName) {
        this.theModuleGroupId = moduleGroupId;
        this.theModuleArtifactId = moduleArtifactId;
        this.theModuleVersion = moduleVersion;
        this.theModuleUserNames = moduleUserNames;
        this.theModuleUserDescriptions = moduleUserDescriptions;
        this.theModuleBuildDate = moduleBuildDate;
        this.theModuleLicense = license;
        this.theRuntimeModuleRequirements = runtimeModuleRequirements;
        this.theModuleJar = moduleJar;
        this.theActivationClassName = activationClassName;
        this.theRunClassName = runClassName;
        this.theResourceJarEntryPrefix = moduleJar == null ? "" : (moduleJar.getName().endsWith(".war") ? WAR_RESOURCE_JAR_ENTRY_PREFIX : "");
    }

    public final String getModuleGroupId() {
        return this.theModuleGroupId;
    }

    public final String getModuleArtifactId() {
        return this.theModuleArtifactId;
    }

    public String getModuleUserName() {
        return this.getModuleUserName(Locale.getDefault());
    }

    public String getModuleUserName(Locale loc) {
        String ret = null;
        if (this.theModuleUserNames != null) {
            String key1 = loc.getCountry();
            if (loc.getLanguage() != null) {
                String key2 = key1 + "." + loc.getLanguage();
                if (loc.getVariant() != null) {
                    String key3 = key2 + "." + loc.getVariant();
                    ret = this.theModuleUserNames.get(key3);
                }
                if (ret == null) {
                    ret = this.theModuleUserNames.get(key2);
                }
            }
            if (ret == null) {
                ret = this.theModuleUserNames.get(key1);
            }
        }
        if (ret == null) {
            ret = this.toString();
        }
        return ret;
    }

    public String getModuleUserDescription(Locale loc) {
        String ret = null;
        if (this.theModuleUserDescriptions != null) {
            String key1 = loc.getCountry();
            if (loc.getLanguage() != null) {
                String key2 = key1 + "." + loc.getLanguage();
                if (loc.getVariant() != null) {
                    String key3 = key2 + "." + loc.getVariant();
                    ret = this.theModuleUserDescriptions.get(key3);
                }
                if (ret == null) {
                    ret = this.theModuleUserDescriptions.get(key2);
                }
            }
            if (ret == null) {
                ret = this.theModuleUserDescriptions.get(key1);
            }
        }
        return ret;
    }

    public Map<String, String> getModuleUserNames() {
        return this.theModuleUserNames;
    }

    public Map<String, String> getModuleUserDescriptions() {
        return this.theModuleUserDescriptions;
    }

    public final String getModuleVersion() {
        return this.theModuleVersion;
    }

    public final long getModuleBuildDate() {
        return this.theModuleBuildDate;
    }

    public final ModuleLicense getModuleLicense() {
        return this.theModuleLicense;
    }

    public final ModuleRequirement[] getRuntimeModuleRequirements() {
        return this.theRuntimeModuleRequirements;
    }

    public final JarFile getProvidesJar() {
        return this.theModuleJar;
    }

    public final String getResourceJarEntryPrefix() {
        return this.theResourceJarEntryPrefix;
    }

    public final String getActivationClassName() {
        return this.theActivationClassName;
    }

    public final String getRunClassName() {
        return this.theRunClassName;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ModuleMeta realOther = (ModuleMeta)other;
        if (!this.theModuleGroupId.equals(realOther.theModuleGroupId)) {
            return false;
        }
        if (!this.theModuleArtifactId.equals(realOther.theModuleArtifactId)) {
            return false;
        }
        return this.theModuleVersion.equals(realOther.theModuleVersion);
    }

    public int hashCode() {
        int ret = this.theModuleGroupId.hashCode() % this.theModuleArtifactId.hashCode() % this.theModuleVersion.hashCode();
        return ret;
    }

    protected Module createModule(AbstractModuleRegistry registry, ClassLoader parentClassLoader) {
        return new Module(this, registry, parentClassLoader);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.theModuleGroupId);
        buf.append(":");
        buf.append(this.theModuleArtifactId);
        buf.append(":");
        buf.append(this.theModuleVersion);
        return buf.toString();
    }
}

