/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleRegistry;
import org.diet4j.core.NoClassDefFoundWithClassLoaderError;

public class ModuleClassLoader
extends ClassLoader {
    protected Module theModule;
    protected ModuleClassLoader[] theDependencyClassLoaders = null;
    protected URLStreamHandler theStreamHandler;
    protected String[] theDoNotLoadClassPrefixes;
    protected HashMap<String, Object> cannotFindTable = new HashMap(20);
    protected static final Object CANNOT_FIND_OBJECT = new Object();
    private static final Logger log = Logger.getLogger(ModuleClassLoader.class.getName());

    public ModuleClassLoader(Module mod, ClassLoader parent, ModuleClassLoader[] dependencyClassLoaders, String[] doNotLoadClassPrefixes) {
        super(parent);
        this.theModule = mod;
        this.theDependencyClassLoaders = dependencyClassLoaders;
        this.theDoNotLoadClassPrefixes = doNotLoadClassPrefixes;
    }

    public Module getModule() {
        return this.theModule;
    }

    public ModuleRegistry getModuleRegistry() {
        return this.theModule.getModuleRegistry();
    }

    public void addModuleJarUrls(Set<URL> set) throws MalformedURLException {
        set.add(new File(this.theModule.getModuleMeta().getProvidesJar().getName()).toURI().toURL());
        for (ModuleClassLoader dep : this.theDependencyClassLoaders) {
            if (dep == null) continue;
            dep.addModuleJarUrls(set);
        }
    }

    @Override
    public URL getResource(String name) {
        URL ret = this.findResource(name);
        if (ret != null) {
            return ret;
        }
        for (int i = 0; i < this.theDependencyClassLoaders.length; ++i) {
            if (this.theDependencyClassLoaders[i] == null || (ret = this.theDependencyClassLoaders[i].getResource(name)) == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        ClassLoader parent = this.getParent();
        URL localResource = this.getResource(name);
        if (localResource != null) {
            return new CompoundIterator<URL>(localResource, parent.getResources(name));
        }
        return parent.getResources(name);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        boolean closeReporting = false;
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            closeReporting = true;
            log.log(Level.FINER, "loadClassAttemptStart: {0} ({1})", new Object[]{this.theModule, name});
            if (this.cannotFindTable.get(name) == null) {
                ClassLoader consultDefaultClassLoader = null;
                for (String prefix : this.theDoNotLoadClassPrefixes) {
                    if (!name.startsWith(prefix)) continue;
                    consultDefaultClassLoader = this.getClass().getClassLoader();
                    break;
                }
                if (consultDefaultClassLoader != null) {
                    try {
                        c = consultDefaultClassLoader.loadClass(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c == null) {
                    String prefix;
                    String path = name.replace('.', '/').concat(".class");
                    ModuleMeta meta = this.theModule.getModuleMeta();
                    JarFile jar = meta.getProvidesJar();
                    prefix = meta.getResourceJarEntryPrefix();
                    JarEntry entry = jar.getJarEntry(prefix + path);
                    try {
                        byte[] classBytes = ModuleClassLoader.slurpJarEntry(jar, entry);
                        if (classBytes != null && classBytes.length > 0) {
                            int lastDot = name.lastIndexOf(46);
                            if (lastDot != -1) {
                                String pkgName = name.substring(0, lastDot);
                                URL url = new URL("file://" + jar.getName());
                                Manifest man = jar.getManifest();
                                if (this.getAndVerifyPackage(pkgName, man, url) == null) {
                                    if (man != null) {
                                        this.definePackage(pkgName, man, url);
                                    } else {
                                        this.definePackage(pkgName, null, null, null, null, null, null, null);
                                    }
                                }
                            }
                            c = this.defineClass(name, classBytes, 0, classBytes.length);
                        }
                    }
                    catch (IOException ex) {
                        log.log(Level.WARNING, "Failed to read from Jar file " + jar, ex);
                    }
                    catch (NoClassDefFoundWithClassLoaderError ex) {
                        throw ex;
                    }
                    catch (NoClassDefFoundError ex) {
                        throw new NoClassDefFoundWithClassLoaderError(ex.getMessage(), this);
                    }
                    catch (ClassFormatError ex) {
                        log.log(Level.SEVERE, "loadClassAttemptStart: " + this + " (" + name + ")", ex);
                    }
                }
                if (c == null) {
                    for (int i = 0; i < this.theDependencyClassLoaders.length; ++i) {
                        if (this.theDependencyClassLoaders[i] == null) continue;
                        try {
                            c = this.theDependencyClassLoaders[i].loadClass(name, false);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        if (c != null) break;
                    }
                }
            }
        }
        if (c == null) {
            this.cannotFindTable.put(name, CANNOT_FIND_OBJECT);
            if (closeReporting) {
                log.log(Level.FINE, "loadClass failed: Module {0} (class: {1})", new Object[]{this.theModule, name});
            }
            throw new ClassNotFoundException(name + " (ClassLoader for module " + this.theModule.toString() + ")");
        }
        if (resolve) {
            this.resolveClass(c);
        }
        if (closeReporting) {
            log.log(Level.FINER, "loadClass succeeded: {0} ({1})", new Object[]{this.theModule, name});
        }
        return c;
    }

    @Override
    public synchronized URL findResource(String name) {
        String prefix;
        ModuleMeta meta = this.theModule.getModuleMeta();
        JarFile jar = meta.getProvidesJar();
        JarEntry foundEntry = jar.getJarEntry((prefix = meta.getResourceJarEntryPrefix()) + name);
        if (foundEntry == null) {
            return null;
        }
        try {
            StringBuilder urlSpec = new StringBuilder();
            urlSpec.append("jar:file:");
            urlSpec.append(jar.getName());
            urlSpec.append("!/");
            return new URL(new URL(urlSpec.toString()), foundEntry.getName());
        }
        catch (MalformedURLException ex) {
            log.log(Level.SEVERE, "findResource: " + this + " (" + name + ")", ex);
            return null;
        }
    }

    protected static byte[] slurpJarEntry(JarFile file, JarEntry entry) throws IOException {
        int read;
        if (entry == null) {
            return null;
        }
        InputStream inStream = file.getInputStream(entry);
        byte[] buf = new byte[(int)entry.getSize()];
        for (int offset = 0; offset < buf.length; offset += read) {
            read = inStream.read(buf, offset, buf.length - offset);
            if (read > 0) continue;
            log.log(Level.WARNING, "Attempted to read {0} bytes, but only read {1} from JarEntry {2} in {3}", new Object[]{buf.length, offset, entry, file.getName()});
            return null;
        }
        return buf;
    }

    public ModuleClassLoader[] getDependencyClassLoaders() {
        return this.theDependencyClassLoaders;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(100);
        buf.append(this.getClass().getName());
        buf.append(" (Module: ");
        buf.append(this.theModule.toString());
        buf.append(")");
        return buf.toString();
    }

    protected Package getAndVerifyPackage(String pkgname, Manifest man, URL url) {
        Package pkg = this.getPackage(pkgname);
        if (pkg != null) {
            if (pkg.isSealed()) {
                if (!pkg.isSealed(url)) {
                    throw new SecurityException("sealing violation: package " + pkgname + " is sealed");
                }
            } else if (man != null && this.isSealed(pkgname, man)) {
                throw new SecurityException("sealing violation: can't seal package " + pkgname + ": already loaded");
            }
        }
        return pkg;
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    public static class CompoundIterator<T>
    implements Enumeration<T> {
        protected T theFirstElement;
        protected Enumeration<T> theContinued;
        protected boolean doFirst = true;

        public CompoundIterator(T firstElement, Enumeration<T> continued) {
            this.theFirstElement = firstElement;
            this.theContinued = continued;
        }

        @Override
        public boolean hasMoreElements() {
            if (this.doFirst) {
                return true;
            }
            return this.theContinued.hasMoreElements();
        }

        @Override
        public T nextElement() {
            if (this.doFirst) {
                this.doFirst = false;
                return this.theFirstElement;
            }
            return this.theContinued.nextElement();
        }
    }
}

