/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.io.CharConversionException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.diet4j.core.AbstractModuleRegistry;
import org.diet4j.core.MiniModuleMetaMap;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleRequirement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractScanningModuleRegistry
extends AbstractModuleRegistry {
    protected final Map<String, MiniModuleMetaMap> theMetas;
    private static final Logger log = Logger.getLogger(AbstractScanningModuleRegistry.class.getName());
    public static final String ACTIVATION_CLASS_PROPERTY = "diet4j.activationclass";

    protected AbstractScanningModuleRegistry(Map<String, MiniModuleMetaMap> metas, String[] doNotLoadClassPrefixes) {
        super(doNotLoadClassPrefixes);
        this.theMetas = metas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModuleMeta[] determineResolutionCandidates(ModuleRequirement req) {
        ModuleMeta[] found2;
        MiniModuleMetaMap found1;
        Object object = this.RESOLVE_LOCK;
        synchronized (object) {
            found1 = this.theMetas.get(req.getRequiredModuleArtifactId());
        }
        if (found1 == null) {
            return new ModuleMeta[0];
        }
        if (req.getRequiredModuleGroupId() != null) {
            found2 = found1.get(req.getRequiredModuleGroupId());
            if (found2 == null) {
                return new ModuleMeta[0];
            }
            return req.findVersionMatchesFrom(found2);
        }
        found2 = found1.allValues();
        return req.findVersionMatchesFrom(found2);
    }

    protected static void addModuleMeta(ModuleMeta add, HashMap<String, MiniModuleMetaMap> metas) {
        ModuleMeta[] newArray;
        ModuleMeta[] already;
        MiniModuleMetaMap map = metas.get(add.getModuleArtifactId());
        if (map == null) {
            map = new MiniModuleMetaMap();
            metas.put(add.getModuleArtifactId(), map);
        }
        if ((already = map.get(add.getModuleGroupId())) != null) {
            String version = add.getModuleVersion();
            newArray = new ModuleMeta[already.length + 1];
            int offset = 0;
            for (int i = 0; i < already.length; ++i) {
                if (offset == 0) {
                    int comp = AbstractScanningModuleRegistry.rpmvercmp(already[i].getModuleVersion(), version);
                    if (comp == 0) {
                        log.log(Level.WARNING, "Adding module again: {0}: {1}, was: {2}", new Object[]{add.toString(), add.getProvidesJar() != null ? add.getProvidesJar().getName() : "<no jar>", already[i].getProvidesJar() != null ? already[i].getProvidesJar().getName() : "<no jar>"});
                        return;
                    }
                    if (comp < 0) {
                        newArray[i] = add;
                        offset = 1;
                    }
                }
                newArray[i + offset] = already[i];
            }
            if (offset == 0) {
                newArray[newArray.length - 1] = add;
            }
        } else {
            newArray = new ModuleMeta[]{add};
        }
        map.put(add.getModuleGroupId(), newArray);
    }

    @Override
    public Set<String> nameSet() {
        return this.theMetas.keySet();
    }

    @Override
    public Set<String> nameSet(Pattern regex) {
        return this.theMetas.keySet().stream().filter(x -> regex.matcher((CharSequence)x).matches()).collect(Collectors.toSet());
    }

    protected static void addParsedModuleMetasFromJars(List<JarFile> jars, HashMap<String, MiniModuleMetaMap> result) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            for (JarFile jarFile : jars) {
                ZipEntry pomXmlEntry = null;
                JarEntry pomPropertiesEntry = null;
                JarEntry manifestEntry = null;
                File pomSibling = null;
                try {
                    String pomSiblingName = jarFile.getName();
                    pomSiblingName = pomSiblingName.substring(0, pomSiblingName.length() - 3) + "pom";
                    pomSibling = new File(pomSiblingName);
                    if (!pomSibling.canRead()) {
                        pomSibling = null;
                    }
                    Stream<JarEntry> metaFiles = jarFile.stream().filter(f -> f.getName().startsWith("META-INF/"));
                    Iterator iter = metaFiles.iterator();
                    while (iter.hasNext()) {
                        JarEntry f2 = (JarEntry)iter.next();
                        String n = f2.getName();
                        if (n.startsWith("META-INF/maven")) {
                            if (n.endsWith("pom.xml")) {
                                pomXmlEntry = f2;
                                continue;
                            }
                            if (!f2.getName().endsWith("pom.properties")) continue;
                            pomPropertiesEntry = f2;
                            continue;
                        }
                        if (!f2.getName().equals("META-INF/MANIFEST.MF")) continue;
                        manifestEntry = f2;
                    }
                    ModuleMeta meta = AbstractScanningModuleRegistry.parseMetadataFiles(dbf, jarFile, pomXmlEntry != null ? jarFile.getInputStream(pomXmlEntry) : null, pomPropertiesEntry != null ? jarFile.getInputStream(pomPropertiesEntry) : null, manifestEntry != null ? jarFile.getInputStream(manifestEntry) : null, pomSibling != null ? new FileInputStream(pomSibling) : null);
                    if (meta == null) continue;
                    AbstractScanningModuleRegistry.addModuleMeta(meta, result);
                }
                catch (IOException | SAXException ex) {
                    if (pomXmlEntry != null) {
                        if (pomSibling != null) {
                            log.log(Level.WARNING, "Failed to read/parse either entry {0} in file {1} or POM file {2}: {3}", new Object[]{pomXmlEntry.getName(), jarFile.getName(), pomSibling.getAbsolutePath(), ex.getMessage()});
                            continue;
                        }
                        log.log(Level.WARNING, "Failed to read/parse entry {0} in file {1}: {2}", new Object[]{pomXmlEntry.getName(), jarFile.getName(), ex.getMessage()});
                        continue;
                    }
                    if (pomSibling != null) {
                        log.log(Level.WARNING, "Failed to read/parse POM file {0}: {1}", new Object[]{pomSibling.getAbsolutePath(), ex.getMessage()});
                        continue;
                    }
                    log.log(Level.WARNING, "Failed to read/parse a file, but don't know which.", ex);
                }
            }
        }
        catch (ParserConfigurationException ex) {
            log.log(Level.SEVERE, "Failed to instantiate XML parser", ex);
        }
    }

    protected static void addParsedModuleMetasFromDirectories(List<File> dirs, HashMap<String, MiniModuleMetaMap> result) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            for (File dir : dirs) {
                File currentlyParsing = null;
                try {
                    Path dirPath = dir.toPath();
                    Stream<Path> metaFiles = Files.walk(dir.toPath(), new FileVisitOption[0]).map(d -> dirPath.relativize((Path)d)).filter(f -> f.toString().startsWith("maven/"));
                    Iterator iter = metaFiles.iterator();
                    while (iter.hasNext()) {
                        ModuleMeta meta;
                        Path p = (Path)iter.next();
                        String n = p.toString();
                        if (!n.endsWith("pom.xml") || (meta = AbstractScanningModuleRegistry.parseMetadataFiles(dbf, null, new FileInputStream(currentlyParsing = new File(dir, n)), null, null, null)) == null) continue;
                        AbstractScanningModuleRegistry.addModuleMeta(meta, result);
                    }
                }
                catch (IOException | SAXException ex) {
                    log.log(Level.WARNING, "Failed to read/parse file " + (currentlyParsing != null ? currentlyParsing.getAbsolutePath() : "?"), ex);
                }
            }
        }
        catch (ParserConfigurationException ex) {
            log.log(Level.SEVERE, "Failed to configure XML parser", ex);
        }
    }

    protected static ModuleMeta parseMetadataFiles(DocumentBuilderFactory dbf, JarFile jar, InputStream pomXmlEntryStream, InputStream pomPropertiesEntryStream, InputStream manifestEntryStream, InputStream pomFileStream) throws ParserConfigurationException, IOException, SAXException {
        String name;
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        if (pomPropertiesEntryStream != null) {
            Properties shortPomProperties = new Properties();
            shortPomProperties.load(pomPropertiesEntryStream);
            for (String propName : shortPomProperties.stringPropertyNames()) {
                pomProperties.put("project." + propName, shortPomProperties.getProperty(propName));
            }
        }
        if (!pomProperties.containsKey("mavenVersion")) {
            pomProperties.put("mavenVersion", null);
        }
        DocumentBuilder parser = dbf.newDocumentBuilder();
        Document doc = null;
        parser.setErrorHandler(new ErrorHandler(){

            @Override
            public void fatalError(SAXParseException ex) {
            }

            @Override
            public void error(SAXParseException ex) {
            }

            @Override
            public void warning(SAXParseException ex) {
            }
        });
        if (pomFileStream != null) {
            try {
                doc = parser.parse(pomFileStream);
            }
            catch (CharConversionException propName) {
                // empty catch block
            }
        }
        if (doc == null && pomXmlEntryStream != null) {
            try {
                doc = parser.parse(pomXmlEntryStream);
            }
            catch (CharConversionException ex) {
                return null;
            }
        }
        if (doc == null) {
            return null;
        }
        Element root = doc.getDocumentElement();
        root.normalize();
        String moduleGroupId = "${project.groupId}";
        String moduleArtifactId = "${project.artifactId}";
        String moduleVersion = "${project.version}";
        String parentGroupId = null;
        String parentVersion = null;
        ArrayList<ModuleRequirement> runTimeRequirements = new ArrayList<ModuleRequirement>();
        NodeList rootChildren = root.getChildNodes();
        block35: for (int i = 0; i < rootChildren.getLength(); ++i) {
            Node rootChild = rootChildren.item(i);
            String rootChildName = rootChild.getNodeName();
            if (rootChildName == null) continue;
            switch (rootChildName) {
                case "groupId": {
                    moduleGroupId = rootChild.getTextContent();
                    if (pomProperties.containsKey("project.groupId")) continue block35;
                    pomProperties.put("project.groupId", moduleGroupId);
                    continue block35;
                }
                case "artifactId": {
                    moduleArtifactId = rootChild.getTextContent();
                    if (pomProperties.containsKey("project.artifactId")) continue block35;
                    pomProperties.put("project.artifactId", moduleArtifactId);
                    continue block35;
                }
                case "version": {
                    moduleVersion = rootChild.getTextContent();
                    if (pomProperties.containsKey("project.version")) continue block35;
                    pomProperties.put("project.version", moduleVersion);
                    continue block35;
                }
                case "properties": {
                    NodeList propertiesChildren = rootChild.getChildNodes();
                    for (int j = 0; j < propertiesChildren.getLength(); ++j) {
                        Node propertiesChild = propertiesChildren.item(j);
                        String propertiesChildName = propertiesChild.getNodeName();
                        if (propertiesChild.getNodeType() != 1 || propertiesChildName == null) continue;
                        pomProperties.put(propertiesChildName, propertiesChild.getTextContent());
                    }
                    continue block35;
                }
                case "parent": {
                    NodeList parentChildren = rootChild.getChildNodes();
                    for (int j = 0; j < parentChildren.getLength(); ++j) {
                        Node parentChild = parentChildren.item(j);
                        String parentChildName = parentChild.getNodeName();
                        if (parentChildName == null) continue;
                        if (parentChildName.equals("version")) {
                            parentVersion = parentChild.getTextContent();
                            continue;
                        }
                        if (!parentChildName.equals("groupId")) continue;
                        parentGroupId = parentChild.getTextContent();
                    }
                    continue block35;
                }
                case "dependencies": {
                    NodeList dependenciesChildren = rootChild.getChildNodes();
                    for (int j = 0; j < dependenciesChildren.getLength(); ++j) {
                        Node dependenciesChild = dependenciesChildren.item(j);
                        String dependenciesChildName = dependenciesChild.getNodeName();
                        if (dependenciesChildName == null || !dependenciesChildName.equals("dependency")) continue;
                        NodeList dependencyChildren = dependenciesChild.getChildNodes();
                        String dependencyGroupdId = null;
                        String dependencyArtifactId = null;
                        String dependencyVersion = null;
                        String dependencyScope = null;
                        boolean isOptional = false;
                        block39: for (int k = 0; k < dependencyChildren.getLength(); ++k) {
                            Node dependencyChild = dependencyChildren.item(k);
                            String dependencyChildName = dependencyChild.getNodeName();
                            if (dependencyChildName == null) continue;
                            switch (dependencyChildName) {
                                case "groupId": {
                                    dependencyGroupdId = dependencyChild.getTextContent();
                                    continue block39;
                                }
                                case "artifactId": {
                                    dependencyArtifactId = dependencyChild.getTextContent();
                                    continue block39;
                                }
                                case "version": {
                                    dependencyVersion = dependencyChild.getTextContent();
                                    continue block39;
                                }
                                case "scope": {
                                    dependencyScope = dependencyChild.getTextContent();
                                    continue block39;
                                }
                                case "optional": {
                                    isOptional = "true".equalsIgnoreCase(dependencyChild.getTextContent());
                                }
                            }
                        }
                        if (dependencyGroupdId == null || dependencyArtifactId == null || "compile".equals(dependencyScope) || "test".equals(dependencyScope) || "provided".equals(dependencyScope)) continue;
                        ModuleRequirement req = ModuleRequirement.create(dependencyGroupdId, dependencyArtifactId, dependencyVersion, isOptional);
                        runTimeRequirements.add(req);
                    }
                    continue block35;
                }
            }
        }
        if (!pomProperties.containsKey("project.version")) {
            pomProperties.put("project.version", parentVersion);
        }
        if (!pomProperties.containsKey("project.groupId")) {
            pomProperties.put("project.groupId", parentGroupId);
        }
        moduleGroupId = AbstractScanningModuleRegistry.replaceProperties(pomProperties, moduleGroupId);
        moduleArtifactId = AbstractScanningModuleRegistry.replaceProperties(pomProperties, moduleArtifactId);
        if ((moduleVersion = AbstractScanningModuleRegistry.replaceProperties(pomProperties, moduleVersion)) == null || moduleVersion.isEmpty()) {
            moduleVersion = parentVersion;
        }
        if ((moduleVersion == null || moduleVersion.isEmpty()) && (name = jar.getName()).startsWith(moduleArtifactId + "-")) {
            moduleVersion = name.substring(moduleArtifactId.length() + 1, name.length() - 4);
        }
        if (moduleGroupId == null || moduleGroupId.isEmpty()) {
            moduleGroupId = parentGroupId;
        }
        if ("org.diet4j".equals(moduleGroupId) && (moduleArtifactId.equals("diet4j-cmdline") || moduleArtifactId.equals("diet4j-core") || moduleArtifactId.equals("diet4j-tomcat"))) {
            return null;
        }
        if (jar != null) {
            int lastPeriod;
            String jarFileBaseName = jar.getName();
            int lastSlash = jarFileBaseName.lastIndexOf(File.separatorChar);
            if (lastSlash > 0) {
                jarFileBaseName = jarFileBaseName.substring(lastSlash + 1);
            }
            if ((lastPeriod = jarFileBaseName.lastIndexOf(46)) > 0) {
                jarFileBaseName = jarFileBaseName.substring(0, lastPeriod);
            }
            if (!jarFileBaseName.equals(moduleArtifactId + "-" + moduleVersion)) {
                return null;
            }
        }
        String runClassName = null;
        if (manifestEntryStream != null) {
            Properties manifestProperties = new Properties();
            manifestProperties.load(manifestEntryStream);
            runClassName = manifestProperties.getProperty("Main-Class");
        }
        ModuleMeta ret = null;
        if (moduleArtifactId != null) {
            ModuleRequirement[] runTime = new ModuleRequirement[runTimeRequirements.size()];
            for (int i = 0; i < runTime.length; ++i) {
                ModuleRequirement current = (ModuleRequirement)runTimeRequirements.get(i);
                String groupId = current.getRequiredModuleGroupId();
                String version = current.getUninterpretedRequiredModuleVersion();
                String groupId2 = AbstractScanningModuleRegistry.replaceProperties(pomProperties, groupId);
                String version2 = version != null ? AbstractScanningModuleRegistry.replaceProperties(pomProperties, version) : null;
                runTime[i] = (version == null || version.equals(version2)) && groupId.equals(groupId2) ? current : ModuleRequirement.create(groupId2, current.getRequiredModuleArtifactId(), version2, current.isOptional());
            }
            String activationClassName = pomProperties.get(ACTIVATION_CLASS_PROPERTY);
            if (activationClassName != null) {
                activationClassName = AbstractScanningModuleRegistry.replaceProperties(pomProperties, activationClassName);
            }
            ret = new ModuleMeta(moduleGroupId, moduleArtifactId, moduleVersion, null, null, 0L, null, runTime, jar, activationClassName, runClassName);
        }
        return ret;
    }

    protected static String replaceProperties(HashMap<String, String> prop, String s) {
        Pattern p = Pattern.compile("\\$\\{(.+)\\}");
        Matcher m = p.matcher(s);
        StringBuffer b = null;
        while (m.find()) {
            String value = prop.get(m.group(1));
            if (value != null) {
                if (b == null) {
                    b = new StringBuffer();
                }
                m.appendReplacement(b, Matcher.quoteReplacement(value));
                continue;
            }
            if (b != null) {
                m.appendReplacement(b, "");
                continue;
            }
            b = new StringBuffer();
            m.appendReplacement(b, "");
            if (b.length() != 0) continue;
            b = null;
        }
        if (b != null) {
            m.appendTail(b);
            return b.toString();
        }
        b = new StringBuffer();
        m.appendTail(b);
        if (b.length() > 0) {
            return b.toString();
        }
        return null;
    }

    public static int rpmvercmp(String a, String b) {
        if (a == null) {
            a = "0";
        }
        if (b == null) {
            b = "0";
        }
        if (a.equals(b)) {
            return 0;
        }
        int aLen = a.length();
        int bLen = b.length();
        int one = 0;
        int two = 0;
        while (one < aLen && two < bLen) {
            int rc;
            boolean isnum;
            int i1;
            while (one < aLen && !Character.isLetterOrDigit(a.charAt(one))) {
                ++one;
            }
            while (two < bLen && !Character.isLetterOrDigit(b.charAt(two))) {
                ++two;
            }
            if (one >= aLen || two >= bLen) break;
            if (one != two) {
                return one < two ? -1 : 1;
            }
            int i2 = two;
            if (Character.isDigit(a.charAt(i1))) {
                for (i1 = one; i1 < aLen && Character.isDigit(a.charAt(i1)); ++i1) {
                }
                while (i2 < bLen && Character.isDigit(b.charAt(i2))) {
                    ++i2;
                }
                isnum = true;
            } else {
                while (i1 < aLen && Character.isLetter(a.charAt(i1))) {
                    ++i1;
                }
                while (i2 < bLen && Character.isLetter(b.charAt(i2))) {
                    ++i2;
                }
                isnum = false;
            }
            if (one == i1) {
                int ret = -1;
                return ret;
            }
            if (two == i2) {
                int ret = isnum ? 1 : -1;
                return ret;
            }
            if (isnum) {
                while (one < aLen && a.charAt(one) == '0') {
                    ++one;
                }
                while (two < bLen && b.charAt(two) == '0') {
                    ++two;
                }
                if (i1 - one > i2 - two) {
                    int ret = 1;
                    return ret;
                }
                if (i2 - two > i1 - one) {
                    int ret = -1;
                    return ret;
                }
            }
            if ((rc = a.substring(one, i1).compareTo(b.substring(two, i2))) != 0) {
                int ret = rc < 1 ? -1 : 1;
                return ret;
            }
            one = i1;
            two = i2;
        }
        if (one == aLen && two == bLen) {
            int ret = 0;
            return ret;
        }
        int ret = one == aLen && !Character.isLetter(b.charAt(two)) || Character.isLetter(a.charAt(one)) ? -1 : 1;
        return ret;
    }
}

