/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.core;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.diet4j.core.Module;
import org.diet4j.core.ModuleClassLoader;
import org.diet4j.core.ModuleException;
import org.diet4j.core.ModuleMeta;
import org.diet4j.core.ModuleNotFoundException;
import org.diet4j.core.ModuleRegistry;
import org.diet4j.core.ModuleRegistryEvent;
import org.diet4j.core.ModuleRegistryListener;
import org.diet4j.core.ModuleRequirement;
import org.diet4j.core.ModuleResolutionCandidateNotUniqueException;
import org.diet4j.core.ModuleResolutionException;
import org.diet4j.core.NoModuleResolutionCandidateException;

public abstract class AbstractModuleRegistry
extends ModuleRegistry {
    private final HashMap<ModuleMeta, Module> theModules = new HashMap();
    private final HashMap<Module, Module[]> theForwardRuntimeDependencies = new HashMap();
    private final HashMap<Module, Module[]> theRuntimeUses = new HashMap();
    private ArrayList<ModuleRegistryListener> theModuleRegistryListeners = null;
    protected String[] theDoNotLoadClassPrefixes;
    protected final Object RESOLVE_LOCK = new Object();
    private static final Logger log = Logger.getLogger(AbstractModuleRegistry.class.getName());
    public static final String[] DEFAULT_DO_NOT_LOAD_CLASS_PREFIXES = new String[]{"java.", "javax.a", "javax.c", "javax.i", "javax.j", "javax.l", "javax.m", "javax.n", "javax.p", "javax.r", "javax.script", "javax.sec", "javax.so", "javax.sql", "javax.swing", "javax.t", "javax.x", "com.sun.", "sun", "org.diet4j.cmdline", "org.diet4j.core", "org.diet4j.tomcat", "org.ietf.jgss", "org.omg.", "org.w3c.dom", "org.xml.sax"};

    protected AbstractModuleRegistry(String[] doNotLoadClassPrefixes) {
        this.theDoNotLoadClassPrefixes = doNotLoadClassPrefixes;
    }

    @Override
    public final ModuleMeta determineSingleResolutionCandidate(ModuleRequirement req) throws NoModuleResolutionCandidateException, ModuleResolutionCandidateNotUniqueException {
        ModuleMeta[] found = this.determineResolutionCandidates(req);
        switch (found.length) {
            case 0: {
                throw new NoModuleResolutionCandidateException(req);
            }
            case 1: {
                return found[0];
            }
        }
        String groupId = found[0].getModuleGroupId();
        for (int i = 1; i < found.length; ++i) {
            if (groupId.equals(found[i].getModuleGroupId())) continue;
            throw new ModuleResolutionCandidateNotUniqueException(req, found);
        }
        return found[0];
    }

    @Override
    public final Module resolve(ModuleMeta meta) throws ModuleNotFoundException, ModuleResolutionException {
        return this.resolve(meta, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Module resolve(ModuleMeta meta, boolean recursive) throws ModuleNotFoundException, ModuleResolutionException {
        if (meta == null) {
            throw new NullPointerException("Cannot resolve null ModuleMeta");
        }
        Object object = this.RESOLVE_LOCK;
        synchronized (object) {
            Module ret = this.theModules.get(meta);
            if (ret == null) {
                Module[] dependentModules = null;
                if (recursive) {
                    ModuleRequirement[] reqs = meta.getRuntimeModuleRequirements();
                    dependentModules = new Module[reqs.length];
                    for (int i = 0; i < reqs.length; ++i) {
                        Module dependModule = null;
                        ModuleMeta[] dependAds = this.determineResolutionCandidates(reqs[i]);
                        ModuleException chained = null;
                        for (int j = 0; j < dependAds.length; ++j) {
                            try {
                                dependModule = this.resolve(dependAds[j], true);
                                break;
                            }
                            catch (ModuleResolutionException ex) {
                                if (reqs[i].isOptional()) continue;
                                chained = ex;
                                continue;
                            }
                            catch (ModuleNotFoundException ex) {
                                if (reqs[i].isOptional()) continue;
                                chained = ex;
                            }
                        }
                        if (dependModule != null) {
                            dependentModules[i] = dependModule;
                            continue;
                        }
                        if (reqs[i].isOptional()) continue;
                        throw new ModuleResolutionException(meta, reqs[i], (Throwable)chained);
                    }
                }
                if ((ret = meta.createModule(this, this.getClass().getClassLoader())) != null) {
                    this.theModules.put(meta, ret);
                    if (recursive) {
                        this.theForwardRuntimeDependencies.put(ret, dependentModules);
                        for (int i = 0; i < dependentModules.length; ++i) {
                            Module[] uses = this.theRuntimeUses.get(dependentModules[i]);
                            Module[] newUses = null;
                            if (uses == null) {
                                newUses = new Module[]{ret};
                            } else {
                                boolean found = false;
                                for (int j = 0; j < uses.length; ++j) {
                                    if (ret != uses[j]) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    newUses = new Module[uses.length + 1];
                                    System.arraycopy(uses, 0, newUses, 0, uses.length);
                                    newUses[uses.length] = ret;
                                }
                            }
                            if (dependentModules[i] == null) continue;
                            this.theRuntimeUses.put(dependentModules[i], newUses);
                        }
                    }
                } else {
                    throw new NullPointerException("createModule returned null");
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Module getResolutionOf(ModuleMeta meta) {
        Object object = this.RESOLVE_LOCK;
        synchronized (object) {
            return this.theModules.get(meta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Module[] determineRuntimeDependencies(Module theModule) {
        Object object = this.RESOLVE_LOCK;
        synchronized (object) {
            return this.theForwardRuntimeDependencies.get(theModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Module[] determineRuntimeUses(Module theModule) {
        Object object = this.RESOLVE_LOCK;
        synchronized (object) {
            return this.theRuntimeUses.get(theModule);
        }
    }

    @Override
    protected ClassLoader createClassLoader(Module module, ClassLoader parentClassLoader) {
        ClassLoader ret = parentClassLoader;
        try {
            Module[] dependencies = module.getModuleRegistry().determineRuntimeDependencies(module);
            ModuleClassLoader[] dependencyClassLoaders = new ModuleClassLoader[dependencies.length];
            for (int i = 0; i < dependencies.length; ++i) {
                dependencyClassLoaders[i] = dependencies[i] != null ? (ModuleClassLoader)dependencies[i].getClassLoader() : null;
            }
            ret = new ModuleClassLoader(module, parentClassLoader, dependencyClassLoaders, this.theDoNotLoadClassPrefixes);
        }
        catch (MalformedURLException ex) {
            log.log(Level.SEVERE, "Failed to create ModuleClassLoader for " + module, ex);
        }
        return ret;
    }

    @Override
    public final synchronized void addModuleRegistryListener(ModuleRegistryListener newListener) {
        if (this.theModuleRegistryListeners == null) {
            this.theModuleRegistryListeners = new ArrayList();
        }
        this.theModuleRegistryListeners.add(newListener);
    }

    @Override
    public final synchronized void removeModuleRegistryListener(ModuleRegistryListener oldListener) {
        this.theModuleRegistryListeners.remove(oldListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireModuleAddedEvent(ModuleRegistryEvent theEvent) {
        Iterator<ModuleRegistryListener> theIter;
        AbstractModuleRegistry abstractModuleRegistry = this;
        synchronized (abstractModuleRegistry) {
            if (this.theModuleRegistryListeners == null || this.theModuleRegistryListeners.isEmpty()) {
                return;
            }
            theIter = new ArrayList<ModuleRegistryListener>(this.theModuleRegistryListeners).iterator();
        }
        while (theIter.hasNext()) {
            ModuleRegistryListener current = theIter.next();
            current.newModuleAvailable(theEvent);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.nameSet().size() + " known modules)";
    }
}

