/*
 * Decompiled with CFR 0.152.
 */
package org.diet4j.cmdline;

import java.util.HashMap;
import java.util.Map;
import org.diet4j.cmdline.CmdlineBootLoader;

public class CmdlineParameters {
    protected Parameter[] thePars;
    protected Map<String, String[]> theValues = null;

    public CmdlineParameters(Parameter ... pars) {
        this.thePars = pars;
    }

    public String[] parse(String[] args) {
        if (this.theValues != null) {
            throw new IllegalStateException("Parsed already");
        }
        this.theValues = new HashMap<String, String[]>();
        String[] ret = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                args[i] = args[i].substring(1);
                if (args[i].startsWith("-")) {
                    args[i] = args[i].substring(1);
                }
                Parameter foundPar = null;
                for (int p = 0; p < this.thePars.length; ++p) {
                    if (!args[i].equals(this.thePars[p].theName)) continue;
                    foundPar = this.thePars[p];
                    break;
                }
                if (foundPar == null) {
                    CmdlineBootLoader.fatal("Unknown parameter: " + args[i]);
                    continue;
                }
                if (i + foundPar.theNumValues > args.length) {
                    CmdlineBootLoader.fatal("Parameter " + args[i] + " requires " + foundPar.theNumValues + " values.");
                    continue;
                }
                if (this.theValues.containsKey(foundPar.theName)) {
                    if (foundPar.theMayRepeat) {
                        String[] values = this.theValues.get(foundPar.theName);
                        String[] values2 = new String[values.length + foundPar.theNumValues];
                        System.arraycopy(values, 0, values2, 0, values.length);
                        System.arraycopy(args, i + 1, values2, values.length, foundPar.theNumValues);
                        this.theValues.put(foundPar.theName, values2);
                    } else {
                        CmdlineBootLoader.fatal("Parameter must not repeat: " + args[i]);
                    }
                } else {
                    String[] values = new String[foundPar.theNumValues];
                    System.arraycopy(args, i + 1, values, 0, foundPar.theNumValues);
                    this.theValues.put(foundPar.theName, values);
                }
                ++i;
                i += foundPar.theNumValues;
                continue;
            }
            ret = new String[args.length - i];
            System.arraycopy(args, i, ret, 0, args.length - i);
            break;
        }
        if (ret != null) {
            return ret;
        }
        return new String[0];
    }

    public boolean containsKey(String name) {
        return this.theValues.containsKey(name);
    }

    public String get(String name) {
        String[] found = this.theValues.get(name);
        if (found == null) {
            return null;
        }
        return found[0];
    }

    public String[] getMany(String name) {
        return this.theValues.get(name);
    }

    public static class Parameter {
        protected String theName;
        protected int theNumValues;
        protected boolean theMayRepeat;

        public Parameter(String name, int numValues) {
            this(name, numValues, false);
        }

        public Parameter(String name, int numValues, boolean mayRepeat) {
            this.theName = name;
            this.theNumValues = numValues;
            this.theMayRepeat = mayRepeat;
        }
    }
}

