/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.templating.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.AbstractParser;
import org.dhatim.delivery.ContentDeliveryConfig;
import org.dhatim.delivery.FilterBypass;
import org.dhatim.delivery.dom.serialize.GhostElementSerializationUnit;
import org.dhatim.delivery.ordering.Consumer;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.io.StreamUtils;
import org.dhatim.templating.AbstractTemplateProcessor;
import org.dhatim.util.ClassUtil;
import org.dhatim.xml.DomUtils;
import org.dhatim.xml.XmlUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@VisitBeforeReport(condition="false")
@VisitAfterReport(summary="Applied XSL Template.", detailTemplate="reporting/XslTemplateProcessor_After.html")
public class XslTemplateProcessor
extends AbstractTemplateProcessor
implements Consumer,
FilterBypass {
    private static Log logger = LogFactory.getLog(XslTemplateProcessor.class);
    private String xslString;
    private Templates xslTemplate;
    private boolean isTemplatelet;
    @ConfigParam(defaultVal="true")
    private boolean enableFilterBypass;
    private volatile Boolean isXMLTargetedConfiguration;
    private final boolean isSynchronized = Boolean.getBoolean("org.dhatim.templating.xslt.synchronized");
    private final DomErrorHandler logErrorHandler = new DomErrorHandler();

    @Override
    protected void loadTemplate(SmooksResourceConfiguration resourceConfig) throws IOException, TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        boolean isInlineXSL = resourceConfig.isInline();
        byte[] xslBytes = resourceConfig.getBytes();
        this.xslString = new String(xslBytes, this.getEncoding().name());
        this.isTemplatelet = this.isTemplatelet(isInlineXSL, new String(xslBytes));
        if (this.isTemplatelet) {
            String templateletWrapper = new String(StreamUtils.readStream((InputStream)ClassUtil.getResourceAsStream((String)"doc-files/templatelet.xsl", this.getClass())));
            String templatelet = new String(xslBytes);
            templateletWrapper = StringUtils.replace((String)templateletWrapper, (String)"@@@templatelet@@@", (String)templatelet);
            xslBytes = templateletWrapper.getBytes();
            this.xslString = new String(xslBytes, this.getEncoding().name());
        }
        boolean failOnWarning = resourceConfig.getBoolParameter("failOnWarning", true);
        StreamSource xslStreamSource = new StreamSource(new StringReader(this.xslString));
        transformerFactory.setErrorListener(new XslErrorListener(failOnWarning));
        this.xslTemplate = transformerFactory.newTemplates(xslStreamSource);
    }

    private boolean isTemplatelet(boolean inlineXSL, String templateCode) {
        try {
            Document xslDoc = XmlUtil.parseStream((Reader)new StringReader(templateCode), (ErrorHandler)this.logErrorHandler);
            Element rootElement = xslDoc.getDocumentElement();
            String rootElementNS = rootElement.getNamespaceURI();
            return inlineXSL && (rootElementNS == null || !rootElementNS.equals("http://www.w3.org/1999/XSL/Transform") || !DomUtils.getName((Element)rootElement).equals("stylesheet"));
        }
        catch (ParserConfigurationException e) {
            throw new SmooksConfigurationException("Unable to parse XSL Document (Stylesheet/Templatelet).", (Throwable)e);
        }
        catch (IOException e) {
            throw new SmooksConfigurationException("Unable to parse XSL Document (Stylesheet/Templatelet).", (Throwable)e);
        }
        catch (SAXException e) {
            return inlineXSL;
        }
    }

    public boolean consumes(Object object) {
        return this.xslString.indexOf(object.toString()) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void visit(Element element, ExecutionContext executionContext) throws SmooksException {
        Element ghostElement;
        block10: {
            Document ownerDoc = element.getOwnerDocument();
            ghostElement = GhostElementSerializationUnit.createElement((Document)ownerDoc);
            try {
                if (this.isSynchronized) {
                    Templates templates = this.xslTemplate;
                    synchronized (templates) {
                        this.performTransform(element, ghostElement, ownerDoc);
                        break block10;
                    }
                }
                this.performTransform(element, ghostElement, ownerDoc);
            }
            catch (TransformerException e) {
                throw new SmooksException("Error applying XSLT to node [" + executionContext.getDocumentSource() + ":" + DomUtils.getXPath((Node)element) + "]", (Throwable)e);
            }
        }
        if (this.getOutputStreamResource() != null || this.getAction() == AbstractTemplateProcessor.Action.BIND_TO) {
            String serializedContent = XmlUtil.serialize((NodeList)ghostElement.getChildNodes());
            Text textNode = element.getOwnerDocument().createTextNode(serializedContent);
            this.processTemplateAction(element, textNode, executionContext);
        } else {
            NodeList children = ghostElement.getChildNodes();
            if (children.getLength() == 1 && children.item(0).getNodeType() == 1) {
                this.processTemplateAction(element, children.item(0), executionContext);
            } else {
                this.processTemplateAction(element, ghostElement, executionContext);
            }
        }
    }

    private void performTransform(Element element, Element transRes, Document ownerDoc) throws TransformerException {
        Transformer transformer = this.xslTemplate.newTransformer();
        if (element == ownerDoc.getDocumentElement()) {
            transformer.transform(new DOMSource(ownerDoc), new DOMResult(transRes));
        } else {
            transformer.transform(new DOMSource(element), new DOMResult(transRes));
        }
    }

    public boolean bypass(ExecutionContext executionContext, Source source, Result result) throws SmooksException {
        if (!this.enableFilterBypass) {
            return false;
        }
        if (!this.isXMLTargetedConfiguration(executionContext)) {
            return false;
        }
        if ((source instanceof StreamSource || source instanceof DOMSource) && (result instanceof StreamResult || result instanceof DOMResult)) {
            try {
                Transformer transformer = this.xslTemplate.newTransformer();
                transformer.transform(source, result);
                return true;
            }
            catch (TransformerConfigurationException e) {
                throw new SmooksException("Error applying XSLT.", (Throwable)e);
            }
            catch (TransformerException e) {
                throw new SmooksException("Error applying XSLT.", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isXMLTargetedConfiguration(ExecutionContext executionContext) {
        if (this.isXMLTargetedConfiguration == null) {
            XslTemplateProcessor xslTemplateProcessor = this;
            synchronized (xslTemplateProcessor) {
                if (this.isXMLTargetedConfiguration == null) {
                    SmooksResourceConfiguration readerConfiguration = AbstractParser.getSAXParserConfiguration((ContentDeliveryConfig)executionContext.getDeliveryConfig());
                    this.isXMLTargetedConfiguration = readerConfiguration != null ? Boolean.valueOf(readerConfiguration.getResource() == null) : Boolean.valueOf(true);
                }
            }
        }
        return this.isXMLTargetedConfiguration;
    }

    private static class DomErrorHandler
    implements ErrorHandler {
        private DomErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            logger.debug((Object)"SaxParseException error was reported : ", (Throwable)exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            logger.debug((Object)"SaxParseException fatal error was reported : ", (Throwable)exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            logger.debug((Object)"SaxParseException warning error was reported : ", (Throwable)exception);
        }
    }

    private static class XslErrorListener
    implements ErrorListener {
        private final boolean failOnWarning;

        public XslErrorListener(boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            if (this.failOnWarning) {
                throw exception;
            }
            logger.debug((Object)"XSL Warning.", (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

