/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.flatfile.variablefield;

import java.util.List;
import org.dhatim.GenericReaderConfigurator;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.flatfile.Binding;
import org.dhatim.flatfile.BindingType;
import org.dhatim.flatfile.FlatFileReader;
import org.dhatim.flatfile.variablefield.VariableFieldRecordParserFactory;

public abstract class VariableFieldRecordParserConfigurator
extends GenericReaderConfigurator {
    private Class<? extends VariableFieldRecordParserFactory> factoryParserClass;
    private boolean indent = false;
    private boolean strict = true;
    private boolean fieldsInMessage = false;
    private Binding binding;

    public VariableFieldRecordParserConfigurator(Class<? extends VariableFieldRecordParserFactory> factoryParserClass) {
        super(FlatFileReader.class);
        this.factoryParserClass = factoryParserClass;
    }

    public VariableFieldRecordParserConfigurator setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public VariableFieldRecordParserConfigurator setStrict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public VariableFieldRecordParserConfigurator setFieldsInMessage(boolean fieldsInMessage) {
        this.fieldsInMessage = fieldsInMessage;
        return this;
    }

    public VariableFieldRecordParserConfigurator setBinding(Binding binding) {
        this.binding = binding;
        return this;
    }

    public List<SmooksResourceConfiguration> toConfig() {
        this.getParameters().setProperty("parserFactory", this.factoryParserClass.getName());
        this.getParameters().setProperty("indent", Boolean.toString(this.indent));
        this.getParameters().setProperty("strict", Boolean.toString(this.strict));
        this.getParameters().setProperty("fields-in-message", Boolean.toString(this.fieldsInMessage));
        if (this.binding != null) {
            this.getParameters().setProperty("bindBeanId", this.binding.getBeanId());
            this.getParameters().setProperty("bindBeanClass", this.binding.getBeanClass().getName());
            this.getParameters().setProperty("bindingType", this.binding.getBindingType().toString());
            if (this.binding.getBindingType() == BindingType.MAP) {
                if (this.binding.getKeyField() == null) {
                    throw new SmooksConfigurationException("CSV 'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.getParameters().setProperty("bindMapKeyField", this.binding.getKeyField());
            }
        }
        return super.toConfig();
    }
}

