/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.dhatim.Smooks;
import org.dhatim.SmooksException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.event.ExecutionEventListener;
import org.dhatim.event.report.HtmlReportGenerator;
import org.dhatim.io.StreamUtils;
import org.dhatim.payload.StringSource;
import org.dhatim.rules.RuleEvalResult;
import org.dhatim.validation.OnFailResult;
import org.dhatim.validation.ValidationResult;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String ... args) throws IOException, SAXException, SmooksException {
        String messageIn = Main.readInputMessage();
        System.out.println("\n\n==============Message In==============");
        System.out.println(new String(messageIn));
        System.out.println("======================================");
        ValidationResult results = Main.runSmooks(messageIn);
        System.out.println("\n==============Validation Result=======");
        System.out.println("Errors:");
        for (OnFailResult result : results.getErrors()) {
            RuleEvalResult rule = result.getFailRuleResult();
            System.out.println("\t" + rule.getRuleName() + ": " + result.getMessage());
            System.out.println("\tSwedish:");
            System.out.println("\t" + result.getMessage(new Locale("sv", "SE")));
        }
        System.out.println("Warnings:");
        for (OnFailResult result : results.getWarnings()) {
            System.out.println("\t" + result.getMessage());
            System.out.println("\tSwedish:");
            System.out.println("\t" + result.getMessage(new Locale("sv", "SE")));
        }
        System.out.println("======================================\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ValidationResult runSmooks(String messageIn) throws IOException, SAXException, SmooksException {
        try (Smooks smooks = new Smooks("smooks-config.xml");){
            ExecutionContext executionContext = smooks.createExecutionContext();
            ValidationResult validationResult = new ValidationResult();
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator("target/report/report.html"));
            smooks.filterSource(executionContext, (Source)new StringSource(messageIn), new Result[]{validationResult});
            ValidationResult validationResult2 = validationResult;
            return validationResult2;
        }
    }

    protected static String readInputMessage() {
        try {
            return StreamUtils.readStreamAsString((InputStream)new FileInputStream("input-message.xml"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading input message.", e);
        }
    }
}

