/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.csv.prog;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.UUID;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.dhatim.FilterSettings;
import org.dhatim.ReaderConfigurator;
import org.dhatim.Smooks;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.csv.CSVRecordParserConfigurator;
import org.dhatim.flatfile.Binding;
import org.dhatim.flatfile.BindingType;
import org.dhatim.payload.JavaResult;

public class CSVMapBinder {
    private String beanId = UUID.randomUUID().toString();
    private Smooks smooks;

    public CSVMapBinder(String fields, Class recordType, String keyField) {
        AssertArgument.isNotNullAndNotEmpty((String)fields, (String)"fields");
        AssertArgument.isNotNull((Object)recordType, (String)"recordType");
        AssertArgument.isNotNullAndNotEmpty((String)keyField, (String)"keyField");
        this.smooks = new Smooks();
        this.smooks.setFilterSettings(FilterSettings.DEFAULT_SAX);
        this.smooks.setReaderConfig((ReaderConfigurator)new CSVRecordParserConfigurator(fields).setBinding(new Binding(this.beanId, recordType, BindingType.MAP).setKeyField(keyField)));
    }

    public Map bind(Reader csvStream) {
        AssertArgument.isNotNull((Object)csvStream, (String)"csvStream");
        JavaResult javaResult = new JavaResult();
        this.smooks.filterSource((Source)new StreamSource(csvStream), new Result[]{javaResult});
        return (Map)javaResult.getBean(this.beanId);
    }

    public Map bind(InputStream csvStream) {
        return this.bind(new InputStreamReader(csvStream));
    }
}

