/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.dhatim.csv.CSVHeaderValidationException;
import org.dhatim.csv.CSVRecordParserFactory;
import org.dhatim.flatfile.variablefield.VariableFieldRecordParser;
import org.xml.sax.InputSource;

public class CSVRecordParser<T extends CSVRecordParserFactory>
extends VariableFieldRecordParser<T> {
    private CSVReader csvLineReader;

    public void setDataSource(InputSource source) {
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            throw new IllegalStateException("Invalid InputSource type supplied to CSVRecordParser.  Must contain a Reader instance.");
        }
        CSVRecordParserFactory factory = (CSVRecordParserFactory)this.getFactory();
        this.csvLineReader = new CSVReader(reader, factory.getSeparator(), factory.getQuoteChar(), factory.getEscapeChar());
    }

    public List<String> nextRecordFieldValues() throws IOException {
        String[] csvRecord = this.csvLineReader.readNext();
        if (csvRecord == null) {
            return null;
        }
        return Arrays.asList(csvRecord);
    }

    protected void validateHeader(List<String> headers) {
        try {
            super.validateHeader(headers);
        }
        catch (IOException e) {
            throw new CSVHeaderValidationException(((CSVRecordParserFactory)this.getFactory()).getRecordMetaData().getFieldNames(), headers);
        }
    }
}

