/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.calc;

import java.io.IOException;
import java.util.Set;
import org.dhatim.SmooksException;
import org.dhatim.calc.CountDirection;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.Fragment;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.annotation.VisitAfterIf;
import org.dhatim.delivery.annotation.VisitBeforeIf;
import org.dhatim.delivery.dom.DOMVisitAfter;
import org.dhatim.delivery.dom.DOMVisitBefore;
import org.dhatim.delivery.ordering.Producer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.delivery.sax.SAXVisitBefore;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.javabean.repository.BeanId;
import org.dhatim.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="!parameters.containsKey('executeAfter') || parameters.executeAfter.value != 'true'")
@VisitAfterIf(condition="parameters.containsKey('executeAfter') && parameters.executeAfter.value == 'true'")
public class Counter
implements SAXVisitBefore,
SAXVisitAfter,
DOMVisitBefore,
DOMVisitAfter,
Producer {
    public static final Long DEFAULT_START_INDEX = new Long(0L);
    public static final int DEFAULT_AMOUNT = 1;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Long start;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Integer amount;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator amountExpression;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator startExpression;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private MVELExpressionEvaluator resetCondition;
    @ConfigParam(defaultVal="INCREMENT", choice={"INCREMENT", "DECREMENT"})
    private String direction;
    private CountDirection countDirection;
    private BeanId beanId;
    @AppContext
    private ApplicationContext appContext;

    @Initialize
    public void initialize() {
        this.beanId = this.appContext.getBeanIdStore().register(this.beanIdName);
        this.countDirection = CountDirection.valueOf(this.direction);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.count(executionContext, new Fragment(element));
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.count(executionContext, new Fragment(element));
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, new Fragment(element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.count(executionContext, new Fragment(element));
    }

    public void count(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Long value = (Long)beanContext.getBean(this.beanId);
        if (value == null || this.resetCondition != null && this.resetCondition.eval((Object)beanContext.getBeanMap())) {
            value = this.getStart(beanContext);
        } else {
            int amount = this.getAmount(beanContext);
            value = this.countDirection == CountDirection.INCREMENT ? Long.valueOf(value + (long)amount) : Long.valueOf(value - (long)amount);
        }
        beanContext.addBean(this.beanId, (Object)value, source);
    }

    private Long getStart(BeanContext beanContext) {
        if (this.start == null && this.startExpression == null) {
            return DEFAULT_START_INDEX;
        }
        if (this.start != null) {
            return this.start;
        }
        Object result = this.startExpression.getValue((Object)beanContext.getBeanMap());
        if (!(result instanceof Long) && !(result instanceof Integer)) {
            throw new SmooksException("The start expression must result in a Integer or a Long");
        }
        return new Long(result.toString());
    }

    private int getAmount(BeanContext beanContext) {
        if (this.amount == null && this.amountExpression == null) {
            return 1;
        }
        if (this.amount != null) {
            return this.amount;
        }
        Object result = this.amountExpression.getValue((Object)beanContext.getBeanMap());
        if (!(result instanceof Integer)) {
            throw new SmooksException("The amount expression must result in a Integer");
        }
        return (Integer)result;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName});
    }
}

