/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.edisax.unedifact.handlers;

import java.io.IOException;
import org.dhatim.edisax.BufferedSegmentListener;
import org.dhatim.edisax.BufferedSegmentReader;
import org.dhatim.edisax.EDIParser;
import org.dhatim.edisax.interchange.ControlBlockHandler;
import org.dhatim.edisax.interchange.InterchangeContext;
import org.dhatim.edisax.model.EdifactModel;
import org.dhatim.edisax.model.internal.Description;
import org.dhatim.edisax.model.internal.Edimap;
import org.dhatim.edisax.model.internal.Segment;
import org.dhatim.edisax.registry.MappingsRegistry;
import org.dhatim.xml.hierarchy.HierarchyChangeListener;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class UNHHandler
implements ControlBlockHandler {
    private Segment unhSegment;
    private Segment untSegment;
    private static UNTSegmentListener untSegmentListener = new UNTSegmentListener();
    private HierarchyChangeListener hierarchyChangeListener;

    public UNHHandler(Segment unhSegment, Segment untSegment, HierarchyChangeListener hierarchyChangeListener) {
        this.unhSegment = unhSegment;
        this.untSegment = untSegment;
        this.hierarchyChangeListener = hierarchyChangeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        int nameComponentIndex;
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        MappingsRegistry registry = interchangeContext.getRegistry();
        segmentReader.moveToNextSegment(false);
        String[] fields = segmentReader.getCurrentSegmentFields();
        String messageName = fields[2];
        EdifactModel mappingModel = registry.getMappingModel(messageName, segmentReader.getDelimiters());
        Edimap ediMap = mappingModel.getEdimap();
        Description description = ediMap.getDescription();
        AttributesImpl attrs = new AttributesImpl();
        String namespace = description.getNamespace();
        String commonNS = null;
        String messageNSPrefix = null;
        if (namespace != null && !namespace.equals("") && (nameComponentIndex = namespace.lastIndexOf(":")) != -1) {
            commonNS = namespace.substring(0, nameComponentIndex) + ":common";
            messageNSPrefix = description.getName().toLowerCase();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", "c", "xmlns:c", "CDATA", commonNS);
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", messageNSPrefix, "xmlns:" + messageNSPrefix, "CDATA", namespace);
        }
        interchangeContext.getControlSegmentParser().startElement("interchangeMessage", this.unhSegment.getNamespace(), true, attrs);
        interchangeContext.mapControlSegment(this.unhSegment, false);
        try {
            EDIParser parser = interchangeContext.newParser(mappingModel);
            segmentReader.setSegmentListener(untSegmentListener);
            if (this.hierarchyChangeListener != null) {
                this.hierarchyChangeListener.attachXMLReader((XMLReader)parser);
            } else if (!interchangeContext.isContainerManagedNamespaceStack()) {
                interchangeContext.getNamespaceDeclarationStack().pushReader((XMLReader)parser);
            }
            parser.parse();
        }
        finally {
            segmentReader.setSegmentListener(null);
            if (this.hierarchyChangeListener != null) {
                this.hierarchyChangeListener.detachXMLReader();
            } else if (!interchangeContext.isContainerManagedNamespaceStack()) {
                interchangeContext.getNamespaceDeclarationStack().popReader();
            }
        }
        interchangeContext.mapControlSegment(this.untSegment, true);
        segmentReader.getSegmentBuffer().setLength(0);
        interchangeContext.getControlSegmentParser().endElement("interchangeMessage", this.unhSegment.getNamespace(), true);
    }

    private static class UNTSegmentListener
    implements BufferedSegmentListener {
        private UNTSegmentListener() {
        }

        @Override
        public boolean onSegment(BufferedSegmentReader bufferedSegmentReader) {
            String[] fields = bufferedSegmentReader.getCurrentSegmentFields();
            return !fields[0].equals("UNT");
        }
    }
}

