/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.edisax.model.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dhatim.edisax.model.internal.ContainerNode;
import org.dhatim.edisax.model.internal.Field;
import org.dhatim.edisax.model.internal.SegmentGroup;

public class Segment
extends SegmentGroup
implements ContainerNode {
    private List<Field> fields;
    private String segcode;
    private Pattern segcodePattern;
    private Boolean truncatable;
    private Boolean ignoreUnmappedFields;
    private String description;
    private String importXmlTag;

    public List<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>();
        }
        return this.fields;
    }

    public Segment addField(Field field) {
        this.getFields().add(field);
        return this;
    }

    @Override
    public String getSegcode() {
        return this.segcode;
    }

    public void setSegcode(String value) {
        this.segcode = value;
        this.segcodePattern = Pattern.compile("^" + this.segcode, 32);
    }

    @Override
    public Pattern getSegcodePattern() {
        return this.segcodePattern;
    }

    @Override
    public boolean isTruncatable() {
        return this.truncatable != null && this.truncatable != false;
    }

    public void setTruncatable(Boolean value) {
        this.truncatable = value;
    }

    public void setIgnoreUnmappedFields(Boolean value) {
        this.ignoreUnmappedFields = value;
    }

    public boolean isIgnoreUnmappedFields() {
        return this.ignoreUnmappedFields != null && this.ignoreUnmappedFields != false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getImportXmlTag() {
        return this.importXmlTag;
    }

    public void setImportXmlTag(String importXmlTag) {
        this.importXmlTag = importXmlTag;
    }
}

