/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.edisax.model.internal;

import java.util.ArrayList;
import java.util.List;
import org.dhatim.edisax.model.internal.ContainerNode;
import org.dhatim.edisax.model.internal.SubComponent;
import org.dhatim.edisax.model.internal.ValueNode;

public class Component
extends ValueNode
implements ContainerNode {
    private List<SubComponent> subComponent;
    private Boolean required;
    private Boolean truncatable;

    public Component() {
    }

    public Component(String xmltag, String namespace, Boolean required) {
        super(xmltag, namespace);
        this.required = required;
        this.truncatable = true;
    }

    public Component(String xmltag, String namespace, Boolean required, Boolean truncatable) {
        super(xmltag, namespace);
        this.required = required;
        this.truncatable = truncatable;
    }

    public List<SubComponent> getSubComponents() {
        if (this.subComponent == null) {
            this.subComponent = new ArrayList<SubComponent>();
        }
        return this.subComponent;
    }

    public Component addSubComponent(SubComponent subComponent) {
        this.getSubComponents().add(subComponent);
        return this;
    }

    public boolean isRequired() {
        return this.required != null && this.required != false;
    }

    public void setRequired(Boolean value) {
        this.required = value;
    }

    @Override
    public boolean isTruncatable() {
        return this.truncatable != null && this.truncatable != false;
    }

    public void setTruncatable(Boolean value) {
        this.truncatable = value;
    }
}

