/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.assertion;

import java.util.Collection;
import java.util.Map;

public abstract class AssertArgument {
    public static void isNotNull(Object arg, String argName) throws IllegalArgumentException {
        if (arg == null) {
            throw new IllegalArgumentException("null '" + argName + "' arg in method call.");
        }
    }

    public static void isNotEmpty(String arg, String argName) throws IllegalArgumentException {
        if (arg != null && arg.trim().length() == 0) {
            throw new IllegalArgumentException("Not null, but empty '" + argName + "' arg in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(String arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.trim().length() == 0) {
            throw new IllegalArgumentException("null or empty '" + argName + "' arg in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Object[] arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.length == 0) {
            throw new IllegalArgumentException("null or empty '" + argName + "' arg in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Collection<?> arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("null or empty '" + argName + "' arg in method call.");
        }
    }

    public static void isNotNullAndNotEmpty(Map<?, ?> arg, String argName) throws IllegalArgumentException {
        if (arg == null || arg.isEmpty()) {
            throw new IllegalArgumentException("null or empty '" + argName + "' arg in method call.");
        }
    }

    public static void isInstanceOf(Object arg, Class clazz, String argName) throws IllegalArgumentException {
        if (clazz.isAssignableFrom(arg.getClass())) {
            throw new IllegalArgumentException("Argument '" + argName + "' is not an instance of '" + clazz.getName() + "'.");
        }
    }
}

