/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.sql.hamcrest.matcher;

import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.dhatim.sql.hamcrest.SqlQuery;
import org.dhatim.sql.hamcrest.matcher.AbstractQueryMatcher;
import org.hamcrest.Description;

public class ValueMatcher<T>
extends AbstractQueryMatcher {
    private final T value;
    private final boolean quoted;

    public ValueMatcher(String name, String xpath, T value, boolean quoted) {
        super(name, xpath);
        this.value = value;
        this.quoted = quoted;
    }

    public void describeTo(Description description) {
        description.appendText(this.getName()).appendText(" is ").appendValue(this.value);
    }

    @Override
    protected boolean matchesSafelyDerived(SqlQuery item) {
        String stringValue = this.quoted ? String.format("'%s'", this.value.toString()) : this.value.toString();
        return item.getTextStream().anyMatch(stringValue::equals);
    }

    @Override
    protected void describeMismatchSafelyDerived(SqlQuery actual, Description mismatchDescription) {
        mismatchDescription.appendText(this.getName() + " for ").appendValue(this.value);
        mismatchDescription.appendText(" was ");
        mismatchDescription.appendValueList("[", ",", "]", (Iterable)actual.children().map(ParseTree::getText).collect(Collectors.toList()));
    }
}

