/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.sql.hamcrest.matcher;

import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.dhatim.sql.hamcrest.SqlQuery;
import org.dhatim.sql.hamcrest.matcher.AbstractQueryMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class IdentifierMatcher
extends AbstractQueryMatcher {
    private final Matcher<String> identifierMatcher;

    public IdentifierMatcher(Matcher<String> identifierMatcher) {
        super("identifier", "//identifier/*");
        this.identifierMatcher = identifierMatcher;
    }

    public void describeTo(Description description) {
        description.appendText(this.getName()).appendText(" is ").appendDescriptionOf(this.identifierMatcher);
    }

    @Override
    protected boolean matchesSafelyDerived(SqlQuery item) {
        return item.children().map(this::extractIdentifier).anyMatch(arg_0 -> this.identifierMatcher.matches(arg_0));
    }

    @Override
    protected void describeMismatchSafelyDerived(SqlQuery actual, Description mismatchDescription) {
        mismatchDescription.appendText(this.getName());
        mismatchDescription.appendText(" was ");
        mismatchDescription.appendValueList("[", ",", "]", (Iterable)actual.children().map(this::extractIdentifier).collect(Collectors.toList()));
    }

    private String extractIdentifier(ParseTree parse) {
        if (parse instanceof TerminalNode) {
            int type = ((TerminalNode)parse).getSymbol().getType();
            if (type == 217) {
                return parse.getText();
            }
            if (type == 218) {
                return parse.getText().substring(1, parse.getText().length() - 1);
            }
        }
        return parse.getText();
    }
}

