/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.sql.hamcrest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.xpath.XPath;
import org.dhatim.sql.hamcrest.SqlParserException;
import org.dhatim.sql.lang.PSQLLexer;
import org.dhatim.sql.lang.PSQLParser;

public class SqlQuery {
    private final PSQLParser parser;
    private final PSQLParser.SqlContext tree;
    private final List<ParseTree> currentElements;

    public static SqlQuery of(String sql) {
        return new SqlQuery(SqlQuery.parse(sql, true));
    }

    public static void printTree(String sql) {
        PSQLParser parser = SqlQuery.parse(sql, false);
        SqlQuery.printTree("", (ParseTree)parser.sql());
    }

    private static void printTree(final String indent, ParseTree tree) {
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk(new ParseTreeListener(){
            private int spaces = 0;

            public void enterEveryRule(ParserRuleContext ctx) {
                this.ln("> " + this.nameOf(ctx.getRuleIndex()));
                ++this.spaces;
            }

            public void exitEveryRule(ParserRuleContext ctx) {
                --this.spaces;
                this.ln("< " + this.nameOf(ctx.getRuleIndex()));
            }

            public void visitErrorNode(ErrorNode node) {
                this.ln("X " + node.getText());
            }

            public void visitTerminal(TerminalNode node) {
                this.ln("| " + this.terminalNameOf(node.getSymbol().getType()) + " => " + node.getText());
            }

            private String nameOf(int id) {
                return PSQLParser.ruleNames[id];
            }

            private String terminalNameOf(int type) {
                return PSQLLexer.VOCABULARY.getDisplayName(type);
            }

            private void ln(String s) {
                System.out.println(indent + this.toSpaces() + s);
            }

            private String toSpaces() {
                return this.space(this.spaces * 2);
            }

            private String space(int n) {
                return Stream.generate(() -> " ").limit(n).collect(Collectors.joining());
            }
        }, tree);
    }

    private static PSQLParser parse(String sql, boolean raiseErrors) {
        CodePointCharStream inputStream = CharStreams.fromString((String)sql);
        PSQLLexer lexer = new PSQLLexer((CharStream)inputStream);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new ParserListener(raiseErrors));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        PSQLParser parser = new PSQLParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)new ParserListener(raiseErrors));
        return parser;
    }

    private SqlQuery(PSQLParser parser) {
        this(parser, parser.sql());
    }

    private SqlQuery(PSQLParser parser, PSQLParser.SqlContext tree) {
        this(parser, tree, Arrays.asList(new ParseTree[]{tree}));
    }

    private SqlQuery(PSQLParser parser, PSQLParser.SqlContext tree, List<ParseTree> current) {
        this.parser = parser;
        this.tree = tree;
        this.currentElements = current;
    }

    public SqlQuery derive(String xpath) {
        List<ParseTree> list = this.currentElements.stream().flatMap(p -> XPath.findAll((ParseTree)p, (String)xpath, (Parser)this.parser).stream()).collect(Collectors.toList());
        return new SqlQuery(this.parser, this.tree, list);
    }

    public SqlQuery derive(int fromIndex, int toIndex) {
        return new SqlQuery(this.parser, this.tree, this.getChildren().subList(fromIndex, toIndex));
    }

    public List<ParseTree> getChildren() {
        return Collections.unmodifiableList(this.currentElements);
    }

    public List<String> getTextChildren() {
        return this.getChildren().stream().map(ParseTree::getText).collect(Collectors.toList());
    }

    public Stream<String> getTextStream() {
        return this.currentElements.stream().map(ParseTree::getText);
    }

    public Stream<ParseTree> children() {
        return this.currentElements.stream();
    }

    public String toString() {
        return this.getTextStream().collect(Collectors.joining(", ", "[", "]"));
    }

    public void printTree() {
        System.out.println("[");
        for (ParseTree tree : this.currentElements) {
            SqlQuery.printTree("   ", tree);
        }
        System.out.println("]");
    }

    private static class ParserListener
    extends BaseErrorListener {
        private final boolean raiseErrors;

        public ParserListener(boolean raiseErrors) {
            this.raiseErrors = raiseErrors;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (this.raiseErrors) {
                throw new SqlParserException(msg, (Throwable)e);
            }
        }
    }
}

