/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.sql.hamcrest;

import java.util.stream.Stream;
import org.dhatim.sql.hamcrest.SqlQuery;
import org.dhatim.sql.hamcrest.matcher.AllMatcher;
import org.dhatim.sql.hamcrest.matcher.DebugMatcher;
import org.dhatim.sql.hamcrest.matcher.IdentifierMatcher;
import org.dhatim.sql.hamcrest.matcher.NotEmpty;
import org.dhatim.sql.hamcrest.matcher.Ordered;
import org.dhatim.sql.hamcrest.matcher.StringMatcher;
import org.dhatim.sql.hamcrest.matcher.TokenMatcher;
import org.dhatim.sql.hamcrest.matcher.ValueContainingMatcher;
import org.dhatim.sql.hamcrest.matcher.ValueMatcher;
import org.dhatim.sql.hamcrest.matcher.XPathMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsAnything;

public class QueryMatchers {
    private static final String NO_PATH = "";

    @SafeVarargs
    public static Matcher<SqlQuery> query(Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.allOf(matchers);
    }

    @SafeVarargs
    public static Matcher<SqlQuery> select(Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.xpath("select", "//select_list", QueryMatchers.orderedAllOf(matchers));
    }

    public static Matcher<SqlQuery> from(Matcher<String> tableNameMatcher) {
        return QueryMatchers.from(new Matcher[]{QueryMatchers.table(tableNameMatcher)});
    }

    @SafeVarargs
    public static Matcher<SqlQuery> from(Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.xpath("from", "//from_clause", QueryMatchers.allOf(matchers));
    }

    @SafeVarargs
    public static Matcher<SqlQuery> having(Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.having(QueryMatchers.allOf(matchers));
    }

    public static Matcher<SqlQuery> having() {
        return QueryMatchers.having(QueryMatchers.notEmpty());
    }

    private static Matcher<SqlQuery> having(Matcher<? super SqlQuery> matcher) {
        return QueryMatchers.xpath("having", "//having_clause", matcher);
    }

    public static Matcher<SqlQuery> where(Matcher<? super SqlQuery> matcher) {
        return QueryMatchers.xpath("where", "//where_clause", matcher);
    }

    public static Matcher<SqlQuery> table(Matcher<String> identifierMatcher) {
        return QueryMatchers.xpath("table", "//table_primary//table_name", QueryMatchers.identifier(identifierMatcher));
    }

    public static Matcher<SqlQuery> identifier(Matcher<String> identifierMatcher) {
        return new IdentifierMatcher(identifierMatcher);
    }

    public static Matcher<SqlQuery> cast(Matcher<? super SqlQuery> operand, String type) {
        return QueryMatchers.xpath("primary", "//casted_value_expression_primary/*", QueryMatchers.orderedAllOf(QueryMatchers.xpath("operand", "//value_expression_primary", operand), QueryMatchers.node("::"), QueryMatchers.keyword("type", "//cast_target", type)));
    }

    public static Matcher<SqlQuery> nullCast(String type) {
        return QueryMatchers.xpath("primary", "//null_casted_value_expression/*", QueryMatchers.orderedAllOf(QueryMatchers.node("NULL"), QueryMatchers.node("::"), QueryMatchers.xpath("cast type", "//cast_target", QueryMatchers.keyword("//data_type", NO_PATH, type))));
    }

    @SafeVarargs
    public static Matcher<SqlQuery> leftJoin(Matcher<String> tableNameMatcher, Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.join(QueryMatchers.allOf(QueryMatchers.keyword("join type", "//join_type", "left"), QueryMatchers.table(tableNameMatcher), QueryMatchers.allOf(matchers)));
    }

    @SafeVarargs
    public static Matcher<SqlQuery> row(Matcher<? super SqlQuery> ... matchers) {
        return QueryMatchers.xpath("row", "//row_value_constructor/*", QueryMatchers.orderedAllOf(matchers));
    }

    public static Matcher<SqlQuery> leftJoin(Matcher<String> tableNameMatcher) {
        return QueryMatchers.join(QueryMatchers.allOf(QueryMatchers.keyword("join type", "//join_type", "left"), QueryMatchers.table(tableNameMatcher)));
    }

    private static Matcher<SqlQuery> join(Matcher<? super SqlQuery> matcher) {
        return QueryMatchers.xpath("join", "//table_reference/joined_table/joined_table_primary", matcher);
    }

    private static Matcher<SqlQuery> comparison(String name, String operator, Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.xpath(name, "//comparison_predicate/*", QueryMatchers.orderedAllOf(left, QueryMatchers.symbol("//comp_op", operator), right));
    }

    public static Matcher<SqlQuery> equality(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.comparison("equality", "=", left, right);
    }

    public static <T> Matcher<SqlQuery> equality(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.equality(left, QueryMatchers.value(right));
    }

    public static Matcher<SqlQuery> equal(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.equality(left, right);
    }

    public static <T> Matcher<SqlQuery> equal(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.equality(left, right);
    }

    public static Matcher<SqlQuery> unequal(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.xpath("unequality", "//comparison_predicate/*", QueryMatchers.orderedAllOf(left, QueryMatchers.token("//comp_op", "NOT_EQUAL"), right));
    }

    public static <T> Matcher<SqlQuery> unequal(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.unequal(left, right);
    }

    public static Matcher<SqlQuery> greaterEqual(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.comparison("greaterEqual", ">=", left, right);
    }

    public static <T> Matcher<SqlQuery> greaterEqual(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.greaterEqual(left, QueryMatchers.value(right));
    }

    public static Matcher<SqlQuery> greater(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.comparison("greater", ">", left, right);
    }

    public static <T> Matcher<SqlQuery> greater(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.greaterEqual(left, QueryMatchers.value(right));
    }

    public static Matcher<SqlQuery> lessEqual(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.comparison("lessEqual", "<=", left, right);
    }

    public static <T> Matcher<SqlQuery> lessEqual(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.lessEqual(left, QueryMatchers.value(right));
    }

    public static Matcher<SqlQuery> less(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.comparison("less", "<", left, right);
    }

    public static <T> Matcher<SqlQuery> less(Matcher<? super SqlQuery> left, T right) {
        return QueryMatchers.less(left, QueryMatchers.value(right));
    }

    private static Matcher<SqlQuery> symbol(String xpath, String literal) {
        return QueryMatchers.xpath(String.format("symbol '%s'", literal), String.format("%s//'%s'", xpath, literal), QueryMatchers.notEmpty());
    }

    private static Matcher<SqlQuery> token(String xpath, String token) {
        return QueryMatchers.xpath(String.format("token %s", token), String.format("%s//%s", xpath, token), QueryMatchers.notEmpty());
    }

    private static Matcher<SqlQuery> token(String token) {
        return QueryMatchers.token(NO_PATH, token);
    }

    public static Matcher<SqlQuery> symbol(String literal) {
        return QueryMatchers.symbol(NO_PATH, literal);
    }

    public static Matcher<SqlQuery> node(String nodeName) {
        return new TokenMatcher(String.format("token '%s'", nodeName), NO_PATH, nodeName);
    }

    @SafeVarargs
    public static Matcher<SqlQuery> call(Matcher<String> functionName, Matcher<SqlQuery> ... params) {
        return QueryMatchers.xpath("function", "//routine_invocation/*", QueryMatchers.orderedAllOf(QueryMatchers.xpath("function name", "//function_name/*", QueryMatchers.identifier(functionName)), QueryMatchers.xpath("arguments", "//sql_argument_list/*", QueryMatchers.orderedAllOf(params))));
    }

    public static <T> Matcher<SqlQuery> position(Matcher<SqlQuery> searched, Matcher<SqlQuery> text) {
        return QueryMatchers.xpath("position", "//position_invocation/*", QueryMatchers.xpath("arguments", "//string_expression/*", QueryMatchers.orderedAllOf(searched, text)));
    }

    private static Matcher<SqlQuery> compute(String name, String containerRule, Matcher<SqlQuery> leftMatcher, String operator, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.xpath(name, "//numeric_value_expression/*", QueryMatchers.orderedAllOf(QueryMatchers.rule(containerRule, containerRule, leftMatcher), QueryMatchers.symbol(operator), QueryMatchers.rule(containerRule, containerRule, rightMatcher)));
    }

    public static Matcher<SqlQuery> add(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.compute("addition", "term", leftMatcher, "+", rightMatcher);
    }

    public static Matcher<SqlQuery> sub(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.compute("substraction", "term", leftMatcher, "-", rightMatcher);
    }

    private static Matcher<SqlQuery> compute2(String name, String containerRule, Matcher<SqlQuery> leftMatcher, String operator, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.xpath(name, "//numeric_value_expression/term/*", QueryMatchers.orderedAllOf(QueryMatchers.rule(containerRule, containerRule, leftMatcher), QueryMatchers.symbol(operator), QueryMatchers.rule(containerRule, containerRule, rightMatcher)));
    }

    public static Matcher<SqlQuery> mul(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.compute2("multiplication", "factor", leftMatcher, "*", rightMatcher);
    }

    public static Matcher<SqlQuery> div(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.compute2("division", "factor", leftMatcher, "/", rightMatcher);
    }

    public static Matcher<SqlQuery> concat(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher) {
        return QueryMatchers.xpath("concat", "//character_value_expression/*", QueryMatchers.orderedAllOf(leftMatcher, rightMatcher));
    }

    public static Matcher<SqlQuery> concat(Matcher<SqlQuery> leftMatcher, Matcher<SqlQuery> rightMatcher, Matcher<SqlQuery> thirdMatcher, Matcher<SqlQuery> ... others) {
        Matcher[] all = (Matcher[])Stream.concat(Stream.of(leftMatcher, rightMatcher, thirdMatcher), Stream.of(others)).toArray(Matcher[]::new);
        return QueryMatchers.xpath("concat", "//character_value_expression/*", QueryMatchers.orderedAllOf(all));
    }

    public static Matcher<SqlQuery> column(Matcher<String> columnNameMatcher) {
        return QueryMatchers.xpath("column", "//column_reference", QueryMatchers.identifier(columnNameMatcher));
    }

    public static Matcher<SqlQuery> column(String columnName) {
        return QueryMatchers.column((Matcher<String>)Matchers.equalTo((Object)columnName));
    }

    private static <T> Matcher<SqlQuery> value(T value) {
        return new ValueMatcher<T>("value", NO_PATH, value, false);
    }

    public static Matcher<SqlQuery> uuidLiteral(String uuid) {
        return new ValueMatcher<String>("literal", "//uuid_literal/*", uuid, true);
    }

    public static Matcher<SqlQuery> literal(Number value) {
        return new ValueMatcher<Number>("literal", NO_PATH, value, false);
    }

    public static Matcher<SqlQuery> literal(String value) {
        return new ValueMatcher<String>("literal", NO_PATH, value, true);
    }

    public static <T> Matcher<SqlQuery> literal(T value) {
        return new ValueMatcher<T>("literal", NO_PATH, value, false);
    }

    public static <T> Matcher<SqlQuery> quotedLiteral(T value) {
        return new ValueMatcher<T>("quoted literal", NO_PATH, value, true);
    }

    public static <T> Matcher<SqlQuery> mayQuotedLiteral(T value) {
        return Matchers.anyOf(QueryMatchers.value(value), QueryMatchers.quotedLiteral(value));
    }

    public static <T> Matcher<SqlQuery> literalContaining(T value) {
        return new ValueContainingMatcher<T>("literal containing", NO_PATH, value);
    }

    public static <T> Matcher<SqlQuery> intervalLiteral(String value) {
        return QueryMatchers.xpath("interval", "//interval_literal/*", QueryMatchers.literal(value));
    }

    public static <T> Matcher<SqlQuery> dateLiteral(String value) {
        return QueryMatchers.xpath("date", "//date_literal/*", QueryMatchers.literal(value));
    }

    public static <T> Matcher<SqlQuery> overlaps() {
        return QueryMatchers.xpath("overlaps", "//overlaps_predicate/*", QueryMatchers.keyword("overlaps keyword", NO_PATH, "overlaps"));
    }

    public static Matcher<SqlQuery> like(Matcher<SqlQuery> operand, Matcher<SqlQuery> pattern) {
        return QueryMatchers.xpath("like matcher", "//pattern_matching_predicate/*", QueryMatchers.orderedAllOf(operand, QueryMatchers.keyword("like keyword", NO_PATH, "like"), pattern));
    }

    private static Matcher<SqlQuery> keyword(String name, String xpath, String keyword) {
        return new StringMatcher(name, xpath, keyword, true);
    }

    private static Matcher<SqlQuery> value(String name, String xpath, String value) {
        return QueryMatchers.value(name, xpath, value, false);
    }

    private static Matcher<SqlQuery> value(String name, String xpath, String value, boolean ignoreCase) {
        return new StringMatcher(name, xpath, value, ignoreCase);
    }

    private static Matcher<SqlQuery> xpath(String name, String xpath, Matcher<? super SqlQuery> matcher) {
        return XPathMatcher.xpath(name, xpath, matcher);
    }

    private static Matcher<SqlQuery> rule(String name, String ruleName, Matcher<? super SqlQuery> matcher) {
        return QueryMatchers.xpath(name, "//" + ruleName + "/*", matcher);
    }

    @SafeVarargs
    public static Matcher<SqlQuery> allOf(Matcher<? super SqlQuery> ... matchers) {
        return AllMatcher.allOf(matchers);
    }

    public static Matcher<SqlQuery> not(Matcher<SqlQuery> matcher) {
        return QueryMatchers.xpath("not", "//boolean_factor/*", QueryMatchers.orderedAllOf(QueryMatchers.keyword("not keyword", NO_PATH, "not"), matcher));
    }

    public static Matcher<SqlQuery> and(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.rule("and", "and_predicate", QueryMatchers.orderedAllOf(left, QueryMatchers.token("AND"), right));
    }

    public static Matcher<SqlQuery> and(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> middle, Matcher<? super SqlQuery> right) {
        return QueryMatchers.rule("and", "and_predicate", QueryMatchers.orderedAllOf(left, QueryMatchers.token("AND"), middle, QueryMatchers.token("AND"), right));
    }

    public static Matcher<SqlQuery> or(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> right) {
        return QueryMatchers.rule("or", "or_predicate", QueryMatchers.orderedAllOf(left, QueryMatchers.token("OR"), right));
    }

    public static Matcher<SqlQuery> or(Matcher<? super SqlQuery> left, Matcher<? super SqlQuery> middle, Matcher<? super SqlQuery> right) {
        return QueryMatchers.rule("or", "or_predicate", QueryMatchers.orderedAllOf(left, QueryMatchers.token("OR"), middle, QueryMatchers.token("OR"), right));
    }

    public static Matcher<SqlQuery> any() {
        return new IsAnything();
    }

    @SafeVarargs
    public static Matcher<SqlQuery> orderedAllOf(Matcher<? super SqlQuery> ... matchers) {
        return Ordered.allOf(matchers);
    }

    private static Matcher<SqlQuery> notEmpty() {
        return new NotEmpty();
    }

    private static Matcher<SqlQuery> print(Matcher<SqlQuery> query) {
        return new DebugMatcher(query);
    }
}

