/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet.read.converter;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.function.Consumer;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.dflib.parquet.read.converter.InstantRead;

class LocalDateTimeConverter
extends PrimitiveConverter {
    private final Consumer<Object> consumer;
    private final LongToLocalDateTime mapper;
    private LocalDateTime[] dict = null;

    public LocalDateTimeConverter(Consumer<Object> consumer, LogicalTypeAnnotation.TimeUnit timeUnit) {
        this.consumer = consumer;
        this.mapper = timeUnit == LogicalTypeAnnotation.TimeUnit.MILLIS ? LocalDateTimeConverter::localDateTimeFromMillisFromEpoch : (timeUnit == LogicalTypeAnnotation.TimeUnit.MICROS ? LocalDateTimeConverter::localDateTimeFromMicrosFromEpoch : LocalDateTimeConverter::localDateTimeFromNanosFromEpoch);
    }

    public void addLong(long timeToEpoch) {
        this.consumer.accept(this.mapper.map(timeToEpoch));
    }

    public void addValueFromDictionary(int dictionaryId) {
        this.consumer.accept(this.dict[dictionaryId]);
    }

    public boolean hasDictionarySupport() {
        return true;
    }

    public void setDictionary(Dictionary dictionary) {
        int maxId = dictionary.getMaxId();
        this.dict = new LocalDateTime[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            this.dict[i] = this.mapper.map(dictionary.decodeToLong(i));
        }
    }

    private static LocalDateTime localDateTimeFromMillisFromEpoch(long millisFromEpoch) {
        Instant instant = InstantRead.instantFromMillisFromEpoch(millisFromEpoch);
        return LocalDateTimeConverter.localDateTimeInUTC(instant);
    }

    private static LocalDateTime localDateTimeFromMicrosFromEpoch(long microsFromEpoch) {
        Instant instant = InstantRead.instantFromMicrosFromEpoch(microsFromEpoch);
        return LocalDateTimeConverter.localDateTimeInUTC(instant);
    }

    private static LocalDateTime localDateTimeFromNanosFromEpoch(long nanosFromEpoch) {
        Instant instant = InstantRead.instantFromNanosFromEpoch(nanosFromEpoch);
        return LocalDateTimeConverter.localDateTimeInUTC(instant);
    }

    private static LocalDateTime localDateTimeInUTC(Instant instant) {
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    @FunctionalInterface
    private static interface LongToLocalDateTime {
        public LocalDateTime map(long var1);
    }
}

