/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.parquet;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.LocalOutputFile;
import org.apache.parquet.io.OutputFile;
import org.dflib.DataFrame;
import org.dflib.Series;
import org.dflib.parquet.CompressionCodec;
import org.dflib.parquet.TimeUnit;
import org.dflib.parquet.write.ColumnMeta;
import org.dflib.parquet.write.DataFrameParquetWriterBuilder;
import org.dflib.parquet.write.DataFrameSchema;
import org.dflib.parquet.write.DecimalConfig;
import org.dflib.parquet.write.WriteConfiguration;
import org.dflib.row.RowProxy;

public class ParquetSaver {
    private boolean createMissingDirs;
    private TimeUnit timeUnit = TimeUnit.MICROS;
    private CompressionCodec compressionCodec;
    private DecimalConfig decimalConfig;

    public ParquetSaver createMissingDirs() {
        this.createMissingDirs = true;
        return this;
    }

    public ParquetSaver timeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
        return this;
    }

    public ParquetSaver bigDecimal(int precision, int scale) {
        this.decimalConfig = new DecimalConfig(precision, scale);
        return this;
    }

    public ParquetSaver compression(CompressionCodec compressionCodec) {
        this.compressionCodec = compressionCodec;
        return this;
    }

    public void save(DataFrame df, File file) {
        this.save(df, file.toPath());
    }

    public void save(DataFrame df, String fileName) {
        this.save(df, new File(fileName));
    }

    public void save(DataFrame df, Path filePath) {
        this.createMissingDirsIfNeeded(filePath);
        try {
            this.doSave(df, filePath);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void doSave(DataFrame df, Path filePath) throws IOException {
        DataFrameSchema dataFrameSchema = this.extractDataFrameSchema(df);
        try (ParquetWriter parquetWriter = ((DataFrameParquetWriterBuilder)((DataFrameParquetWriterBuilder)new DataFrameParquetWriterBuilder((OutputFile)new LocalOutputFile(filePath)).withWriteConfiguration(new WriteConfiguration(this.timeUnit, this.decimalConfig)).withSchema(dataFrameSchema).withCompressionCodec(this.compressionCodecName())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();){
            for (RowProxy r : df) {
                parquetWriter.write((Object)r);
            }
        }
    }

    private void createMissingDirsIfNeeded(Path filePath) {
        File dir;
        if (this.createMissingDirs && (dir = filePath.toFile().getParentFile()) != null) {
            dir.mkdirs();
        }
    }

    private DataFrameSchema extractDataFrameSchema(DataFrame df) {
        ArrayList<ColumnMeta> result = new ArrayList<ColumnMeta>();
        int index = 0;
        for (String column : df.getColumnsIndex()) {
            Series series = df.getColumn(column);
            Class inferredType = series.getInferredType();
            result.add(new ColumnMeta(column, inferredType, index));
            ++index;
        }
        return new DataFrameSchema(result);
    }

    private CompressionCodecName compressionCodecName() {
        if (this.compressionCodec == null) {
            return CompressionCodecName.UNCOMPRESSED;
        }
        switch (this.compressionCodec) {
            case GZIP: {
                return CompressionCodecName.GZIP;
            }
            case ZSTD: {
                return CompressionCodecName.ZSTD;
            }
            case SNAPPY: {
                return CompressionCodecName.SNAPPY;
            }
            case LZ4_RAW: {
                return CompressionCodecName.LZ4_RAW;
            }
        }
        return CompressionCodecName.UNCOMPRESSED;
    }
}

