/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.csv;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Path;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.dflib.DataFrame;
import org.dflib.Index;
import org.dflib.row.RowProxy;

public class CsvSaver {
    private CSVFormat format = CSVFormat.DEFAULT;
    private boolean createMissingDirs;
    private boolean printHeader = true;

    public CsvSaver format(CSVFormat format) {
        this.format = format;
        return this;
    }

    public CsvSaver createMissingDirs() {
        this.createMissingDirs = true;
        return this;
    }

    public CsvSaver noHeader() {
        this.printHeader = false;
        return this;
    }

    public void save(DataFrame df, File file) {
        File dir;
        if (this.createMissingDirs && (dir = file.getParentFile()) != null) {
            dir.mkdirs();
        }
        try (FileWriter out = new FileWriter(file);){
            this.save(df, out);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing CSV to " + String.valueOf(file) + ": " + e.getMessage(), e);
        }
    }

    public void save(DataFrame df, Path filePath) {
        this.save(df, filePath.toFile());
    }

    public void save(DataFrame df, String fileName) {
        this.save(df, new File(fileName));
    }

    public void save(DataFrame df, Appendable out) {
        try {
            CSVPrinter printer = new CSVPrinter(out, this.format);
            if (this.printHeader) {
                this.printHeader(printer, df.getColumnsIndex());
            }
            int len = df.width();
            for (RowProxy r : df) {
                this.printRow(printer, r, len);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing CSV: " + e.getMessage(), e);
        }
    }

    public String saveToString(DataFrame df) {
        StringWriter out = new StringWriter();
        this.save(df, out);
        return out.toString();
    }

    private void printHeader(CSVPrinter printer, Index index) throws IOException {
        for (String label : index) {
            printer.print((Object)label);
        }
        printer.println();
    }

    private void printRow(CSVPrinter printer, RowProxy row, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            printer.print(row.get(i));
        }
        printer.println();
    }
}

