/*
 * Decompiled with CFR 0.152.
 */
package org.dflib.csv;

import java.util.Iterator;
import org.apache.commons.csv.CSVRecord;
import org.dflib.Index;
import org.dflib.csv.CsvHeader;

@FunctionalInterface
interface CsvHeaderFactory {
    public CsvHeader header(Iterator<CSVRecord> var1);

    public static CsvHeaderFactory explicit(Index header) {
        return it -> new CsvHeader(header, null);
    }

    public static CsvHeaderFactory firstRow() {
        return CsvHeaderFactory::firstRow;
    }

    public static CsvHeaderFactory generated() {
        return CsvHeaderFactory::generated;
    }

    private static CsvHeader firstRow(Iterator<CSVRecord> it) {
        if (!it.hasNext()) {
            return new CsvHeader(Index.of((String[])new String[0]), null);
        }
        CSVRecord firstRow = it.next();
        int width = firstRow.size();
        String[] columnNames = new String[width];
        for (int i = 0; i < width; ++i) {
            columnNames[i] = firstRow.get(i);
        }
        return new CsvHeader(Index.of((String[])columnNames), null);
    }

    private static CsvHeader generated(Iterator<CSVRecord> it) {
        CSVRecord firstRow = it.next();
        int width = firstRow.size();
        String[] columnNames = new String[width];
        for (int i = 0; i < width; ++i) {
            columnNames[i] = "c" + i;
        }
        return new CsvHeader(Index.of((String[])columnNames), firstRow);
    }
}

