/*
 * Decompiled with CFR 0.152.
 */
package org.devzendo.commondb.beanminder.persistence.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.devzendo.commondb.beanminder.persistence.dao.TransactionsDao;
import org.devzendo.commondb.beanminder.persistence.dao.impl.JdbcTemplateAccountsDao;
import org.devzendo.commondb.beanminder.persistence.domain.Account;
import org.devzendo.commondb.beanminder.persistence.domain.AccountBalance;
import org.devzendo.commondb.beanminder.persistence.domain.Amount;
import org.devzendo.commondb.beanminder.persistence.domain.CreditDebit$;
import org.devzendo.commondb.beanminder.persistence.domain.CurrentBalance;
import org.devzendo.commondb.beanminder.persistence.domain.Index;
import org.devzendo.commondb.beanminder.persistence.domain.Reconciled$;
import org.devzendo.commondb.beanminder.persistence.domain.Transaction;
import org.devzendo.commondb.util.NormalisedDate$;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001B\u0001\u0003\u0001E\u00111D\u00133cGR+W\u000e\u001d7bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\t\u0006|'BA\u0002\u0005\u0003\u0011IW\u000e\u001d7\u000b\u0005\u00151\u0011a\u00013b_*\u0011q\u0001C\u0001\fa\u0016\u00148/[:uK:\u001cWM\u0003\u0002\n\u0015\u0005Q!-Z1o[&tG-\u001a:\u000b\u0005-a\u0011\u0001C2p[6|g\u000e\u001a2\u000b\u00055q\u0011\u0001\u00033fmj,g\u000eZ8\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0011\u0011DG\u0007\u0002\t%\u00111\u0004\u0002\u0002\u0010)J\fgn]1di&|gn\u001d#b_\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u0007kI\n\u001cG+Z7qY\u0006$X\r\u0005\u0002 Q5\t\u0001E\u0003\u0002\"E\u000511/[7qY\u0016T!a\t\u0013\u0002\t\r|'/\u001a\u0006\u0003K\u0019\nAA\u001b3cG*\u0011qED\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011\u0011\u0006\t\u0002\u0013'&l\u0007\u000f\\3KI\n\u001cG+Z7qY\u0006$X\rC\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0003[=\u0002\"A\f\u0001\u000e\u0003\tAQ!\b\u0016A\u0002yAq!\r\u0001A\u0002\u0013\u0005!'A\u0006bG\u000e|WO\u001c;t\t\u0006|W#A\u001a\u0011\u00059\"\u0014BA\u001b\u0003\u0005]QEMY2UK6\u0004H.\u0019;f\u0003\u000e\u001cw.\u001e8ug\u0012\u000bw\u000eC\u00048\u0001\u0001\u0007I\u0011\u0001\u001d\u0002\u001f\u0005\u001c7m\\;oiN$\u0015m\\0%KF$\"!\u000f\u001f\u0011\u0005MQ\u0014BA\u001e\u0015\u0005\u0011)f.\u001b;\t\u000fu2\u0014\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\t\r}\u0002\u0001\u0015)\u00034\u00031\t7mY8v]R\u001cH)Y8!\u0011\u0015\t\u0005\u0001\"\u0001C\u0003i1\u0017N\u001c3Ue\u0006t7/Y2uS>t7OR8s\u0003\u000e\u001cw.\u001e8u)\t\u0019U\u000bE\u0002E\u0019>s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!\u0003\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\tYE#A\u0004qC\u000e\\\u0017mZ3\n\u00055s%\u0001\u0002'jgRT!a\u0013\u000b\u0011\u0005A\u001bV\"A)\u000b\u0005I3\u0011A\u00023p[\u0006Lg.\u0003\u0002U#\nYAK]1og\u0006\u001cG/[8o\u0011\u00151\u0006\t1\u0001X\u0003\u001d\t7mY8v]R\u0004\"\u0001\u0015-\n\u0005e\u000b&aB!dG>,h\u000e\u001e\u0005\u00067\u0002!\t\u0001X\u0001'M&tG\r\u0016:b]N\f7\r^5p]N4uN]!dG>,h\u000e\u001e\"z\u0013:$W\r\u001f*b]\u001e,G\u0003B\"^=\u000eDQA\u0016.A\u0002]CQa\u0018.A\u0002\u0001\f\u0011B\u001a:p[&sG-\u001a=\u0011\u0005M\t\u0017B\u00012\u0015\u0005\rIe\u000e\u001e\u0005\u0006Ij\u0003\r\u0001Y\u0001\bi>Le\u000eZ3y\u0011\u00151\u0007\u0001\"\u0001h\u0003=\u0019\u0018M^3Ue\u0006t7/Y2uS>tGc\u00015lYB!1#[,P\u0013\tQGC\u0001\u0004UkBdWM\r\u0005\u0006-\u0016\u0004\ra\u0016\u0005\u0006[\u0016\u0004\raT\u0001\fiJ\fgn]1di&|g\u000eC\u0003p\u0001\u0011\u0005\u0001/A\teK2,G/\u001a+sC:\u001c\u0018m\u0019;j_:$2aV9s\u0011\u00151f\u000e1\u0001X\u0011\u0015ig\u000e1\u0001P\u0011\u0015!\b\u0001\"\u0001v\u0003]9W\r\u001e(v[\n,'o\u00144Ue\u0006t7/Y2uS>t7\u000f\u0006\u0002am\")ak\u001da\u0001/\")\u0001\u0010\u0001C\u0005s\u0006\u00115/\u001e2ue\u0006\u001cG\u000fR3mi\u00064%o\\7Ue\u0006t7/Y2uS>t\u0017iY2pk:$()\u00197b]\u000e,\u0017I\u001c3EK\u000e\u0014X-\\3oi&sG-\u001a=Cs&sG-\u001a=\u0015\teR80 \u0005\u0006-^\u0004\ra\u0016\u0005\u0006y^\u0004\r\u0001Y\u0001\u0011iJ\fgn]1di&|g.\u00138eKbDQA`<A\u0002\u0001\fq\u0002Z3mi\u0006$vnU;ciJ\f7\r\u001e\u0005\b\u0003\u0003\u0001A\u0011BA\u0002\u0003U!W\r\\3uKR\u0013\u0018M\\:bGRLwN\u001c\"z\u0013\u0012$2!OA\u0003\u0011\u0015iw\u00101\u0001P\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\ta#\u001a8tkJ,GK]1og\u0006\u001cG/[8o'\u00064X\r\u001a\u000b\u0004s\u00055\u0001BB7\u0002\b\u0001\u0007q\nC\u0004\u0002\u0012\u0001!I!a\u0005\u0002\u001f1|\u0017\r\u001a+sC:\u001c\u0018m\u0019;j_:$2aTA\u000b\u0011\u0019i\u0017q\u0002a\u0001\u001f\"9\u0011\u0011\u0003\u0001\u0005\n\u0005eA#B(\u0002\u001c\u0005u\u0001B\u0002,\u0002\u0018\u0001\u0007q\u000bC\u0004\u0002 \u0005]\u0001\u0019\u00011\u0002\u000b%tG-\u001a=\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&\u0005\tR\u000f\u001d3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0015\u0007=\u000b9\u0003C\u0004\u0002*\u0005\u0005\u0002\u0019A(\u0002%U\u0004H-\u0019;fIR\u0013\u0018M\\:bGRLwN\u001c\u0005\b\u0003G\u0001A\u0011BA\u0017)\u0015A\u0017qFA\u0019\u0011\u00191\u00161\u0006a\u0001/\"9\u0011\u0011FA\u0016\u0001\u0004y\u0005bBA\u001b\u0001\u0011%\u0011qG\u0001+C\u0012$G)\u001a7uCR{GK]1og\u0006\u001cG/[8o\u0003\u000e\u001cw.\u001e8u\u0005\u0006d\u0017M\\2f\u0005fLe\u000eZ3y)\u001dI\u0014\u0011HA\u001e\u0003{AaAVA\u001a\u0001\u00049\u0006bBA\u0010\u0003g\u0001\r\u0001\u0019\u0005\b\u0003\u007f\t\u0019\u00041\u0001a\u0003)!W\r\u001c;b)>\fE\r\u001a\u0005\b\u0003\u0007\u0002A\u0011BA#\u0003EIgn]3siR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0006Q\u0006\u001d\u0013\u0011\n\u0005\u0007-\u0006\u0005\u0003\u0019A,\t\r5\f\t\u00051\u0001P\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f\nqbZ3u'&<g.\u001a3B[>,h\u000e\u001e\u000b\u0004A\u0006E\u0003BB7\u0002L\u0001\u0007q\nC\u0004\u0002V\u0001!I!a\u0016\u0002/\r\u0014X-\u0019;f)J\fgn]1di&|g.T1qa\u0016\u0014HCAA-%\u0019\tY&a\u0018\u0002p\u00199\u0011QLA*\u0001\u0005e#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003BA1\u0003Wj!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0005Y\u0006twM\u0003\u0002\u0002j\u0005!!.\u0019<b\u0013\u0011\ti'a\u0019\u0003\r=\u0013'.Z2u!\u0011y\u0012\u0011O(\n\u0007\u0005M\u0004E\u0001\fQCJ\fW.\u001a;fe&TX\r\u001a*po6\u000b\u0007\u000f]3s\u0001")
public class JdbcTemplateTransactionsDao
implements TransactionsDao {
    private final SimpleJdbcTemplate jdbcTemplate;
    private JdbcTemplateAccountsDao accountsDao;

    public JdbcTemplateAccountsDao accountsDao() {
        return this.accountsDao;
    }

    public void accountsDao_$eq(JdbcTemplateAccountsDao x$1) {
        this.accountsDao = x$1;
    }

    @Override
    public List<Transaction> findTransactionsForAccount(Account account) {
        this.accountsDao().ensureAccountSaved(account);
        String sql = "SELECT id, accountId, index, amount, isCredit, isReconciled, transactionDate, accountBalance FROM Transactions WHERE accountId = ?ORDER BY index ASC";
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(sql, this.createTransactionMapper(), new Object[]{Predef$.MODULE$.int2Integer(account.id())})).asScala()).toList();
    }

    @Override
    public List<Transaction> findTransactionsForAccountByIndexRange(Account account, int fromIndex, int toIndex) {
        this.accountsDao().ensureAccountSaved(account);
        String sql = "SELECT id, accountId, index, amount, isCredit, isReconciled, transactionDate, accountBalance FROM Transactions WHERE accountId = ? AND (index >= ? AND index <= ?)ORDER BY index ASC";
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.jdbcTemplate.query(sql, this.createTransactionMapper(), new Object[]{Predef$.MODULE$.int2Integer(account.id()), Predef$.MODULE$.int2Integer(fromIndex), Predef$.MODULE$.int2Integer(toIndex)})).asScala()).toList();
    }

    @Override
    public Tuple2<Account, Transaction> saveTransaction(Account account, Transaction transaction) {
        this.accountsDao().ensureAccountSaved(account);
        return transaction.id() == -1 ? this.insertTransaction(account, transaction) : this.updateTransaction(account, transaction);
    }

    @Override
    public Account deleteTransaction(Account account, Transaction transaction) {
        this.accountsDao().ensureAccountSaved(account);
        this.ensureTransactionSaved(transaction);
        Account reloadedAccount = this.accountsDao().loadAccount(account);
        Transaction reloadedTransaction = this.loadTransaction(transaction);
        int transactionAmountSigned = this.getSignedAmount(reloadedTransaction);
        Account newBalanceAccount = new Account(reloadedAccount.id(), reloadedAccount.name(), reloadedAccount.withBank(), reloadedAccount.accountCode(), reloadedAccount.initialBalance(), new CurrentBalance(BoxesRunTime.unboxToInt((Object)reloadedAccount.currentBalance().toRepresentation()) - transactionAmountSigned));
        Account updatedAccount = this.accountsDao().updateAccount(newBalanceAccount);
        int numberOfTransactions = this.getNumberOfTransactions(reloadedAccount);
        this.deleteTransactionById(reloadedTransaction);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)reloadedTransaction.index().toRepresentation()) + 1), numberOfTransactions).foreach$mVc$sp((Function1)new Serializable(this, transactionAmountSigned, updatedAccount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JdbcTemplateTransactionsDao $outer;
            private final int transactionAmountSigned$1;
            private final Account updatedAccount$1;

            public final void apply(int index) {
                this.apply$mcVI$sp(index);
            }

            public void apply$mcVI$sp(int index) {
                this.$outer.org$devzendo$commondb$beanminder$persistence$dao$impl$JdbcTemplateTransactionsDao$$subtractDeltaFromTransactionAccountBalanceAndDecrementIndexByIndex(this.updatedAccount$1, index, this.transactionAmountSigned$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.transactionAmountSigned$1 = transactionAmountSigned$1;
                this.updatedAccount$1 = updatedAccount$1;
            }
        });
        return updatedAccount;
    }

    @Override
    public int getNumberOfTransactions(Account account) {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM Transactions WHERE accountId = ?", new Object[]{Predef$.MODULE$.int2Integer(account.id())});
    }

    public void org$devzendo$commondb$beanminder$persistence$dao$impl$JdbcTemplateTransactionsDao$$subtractDeltaFromTransactionAccountBalanceAndDecrementIndexByIndex(Account account, int transactionIndex, int deltaToSubtract) {
        Transaction transaction = this.loadTransaction(account, transactionIndex);
        Transaction updatedTransaction = new Transaction(transaction.id(), transaction.accountId(), new Index(transactionIndex - 1), transaction.amount(), transaction.isCredit(), transaction.isReconciled(), transaction.transactionDate(), new AccountBalance(BoxesRunTime.unboxToInt((Object)transaction.accountBalance().toRepresentation()) - deltaToSubtract));
        this.updateTransaction(updatedTransaction);
    }

    private void deleteTransactionById(Transaction transaction) {
        this.jdbcTemplate.update("DELETE FROM Transactions WHERE id = ?", new Object[]{Predef$.MODULE$.int2Integer(transaction.id())});
    }

    private void ensureTransactionSaved(Transaction transaction) {
        if (transaction.id() == -1) {
            throw new DataIntegrityViolationException("Cannot process an unsaved transaction");
        }
    }

    private Transaction loadTransaction(Transaction transaction) {
        String sql = "SELECT id, accountId, index, amount, isCredit, isReconciled, transactionDate, accountBalance FROM Transactions WHERE id = ?";
        return (Transaction)this.jdbcTemplate.queryForObject(sql, this.createTransactionMapper(), new Object[]{Predef$.MODULE$.int2Integer(transaction.id())});
    }

    private Transaction loadTransaction(Account account, int index) {
        String sql = "SELECT id, accountId, index, amount, isCredit, isReconciled, transactionDate, accountBalance FROM Transactions WHERE accountId = ? AND index = ?";
        return (Transaction)this.jdbcTemplate.queryForObject(sql, this.createTransactionMapper(), new Object[]{Predef$.MODULE$.int2Integer(account.id()), Predef$.MODULE$.int2Integer(index)});
    }

    private Transaction updateTransaction(Transaction updatedTransaction) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = new Object[7];
        objectArray2[0] = updatedTransaction.index().toRepresentation();
        objectArray2[1] = updatedTransaction.amount().toRepresentation();
        Enumeration.Value value = updatedTransaction.isCredit();
        Enumeration.Value value2 = CreditDebit$.MODULE$.Credit();
        objectArray2[2] = BoxesRunTime.boxToBoolean((!(value != null ? !value.equals(value2) : value2 != null) ? 1 : 0) != 0);
        Enumeration.Value value3 = updatedTransaction.isReconciled();
        Enumeration.Value value4 = Reconciled$.MODULE$.Reconciled();
        objectArray2[3] = BoxesRunTime.boxToBoolean((!(value3 != null ? !value3.equals(value4) : value4 != null) ? 1 : 0) != 0);
        objectArray2[4] = updatedTransaction.transactionDate().toRepresentation();
        objectArray2[5] = updatedTransaction.accountBalance().toRepresentation();
        objectArray2[6] = Predef$.MODULE$.int2Integer(updatedTransaction.id());
        objectArray[0] = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray2), ClassTag$.MODULE$.Any());
        this.jdbcTemplate.update("UPDATE Transactions SET index = ?, amount = ?, isCredit = ?, isReconciled = ?, transactionDate = ?, accountBalance = ? WHERE id = ?", objectArray);
        return updatedTransaction;
    }

    private Tuple2<Account, Transaction> updateTransaction(Account account, Transaction updatedTransaction) {
        Account reloadedAccount = this.accountsDao().loadAccount(account);
        Transaction committedTransaction = this.loadTransaction(updatedTransaction);
        int committedAmountSigned = this.getSignedAmount(committedTransaction);
        int updatedAmountSigned = this.getSignedAmount(updatedTransaction);
        int deltaToAdd = updatedAmountSigned - committedAmountSigned;
        Account newBalanceAccount = new Account(reloadedAccount.id(), reloadedAccount.name(), reloadedAccount.withBank(), reloadedAccount.accountCode(), reloadedAccount.initialBalance(), new CurrentBalance(BoxesRunTime.unboxToInt((Object)reloadedAccount.currentBalance().toRepresentation()) + deltaToAdd));
        Account updatedAccount = this.accountsDao().updateAccount(newBalanceAccount);
        Transaction newUpdatedTransaction = new Transaction(committedTransaction.id(), committedTransaction.accountId(), committedTransaction.index(), updatedTransaction.amount(), updatedTransaction.isCredit(), updatedTransaction.isReconciled(), updatedTransaction.transactionDate(), new AccountBalance(BoxesRunTime.unboxToInt((Object)committedTransaction.accountBalance().toRepresentation()) + deltaToAdd));
        Transaction savedUpdatedTransaction = this.updateTransaction(newUpdatedTransaction);
        int numberOfTransactions = this.getNumberOfTransactions(reloadedAccount);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)savedUpdatedTransaction.index().toRepresentation()) + 1), numberOfTransactions).foreach$mVc$sp((Function1)new Serializable(this, deltaToAdd, updatedAccount){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JdbcTemplateTransactionsDao $outer;
            private final int deltaToAdd$1;
            private final Account updatedAccount$2;

            public final void apply(int index) {
                this.apply$mcVI$sp(index);
            }

            public void apply$mcVI$sp(int index) {
                this.$outer.org$devzendo$commondb$beanminder$persistence$dao$impl$JdbcTemplateTransactionsDao$$addDeltaToTransactionAccountBalanceByIndex(this.updatedAccount$2, index, this.deltaToAdd$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.deltaToAdd$1 = deltaToAdd$1;
                this.updatedAccount$2 = updatedAccount$2;
            }
        });
        return new Tuple2((Object)updatedAccount, (Object)savedUpdatedTransaction);
    }

    public void org$devzendo$commondb$beanminder$persistence$dao$impl$JdbcTemplateTransactionsDao$$addDeltaToTransactionAccountBalanceByIndex(Account account, int index, int deltaToAdd) {
        Transaction transaction = this.loadTransaction(account, index);
        Transaction updatedTransaction = new Transaction(transaction.id(), transaction.accountId(), transaction.index(), transaction.amount(), transaction.isCredit(), transaction.isReconciled(), transaction.transactionDate(), new AccountBalance(BoxesRunTime.unboxToInt((Object)transaction.accountBalance().toRepresentation()) + deltaToAdd));
        this.updateTransaction(updatedTransaction);
    }

    private Tuple2<Account, Transaction> insertTransaction(Account account, Transaction transaction) {
        Account reloadedAccount = this.accountsDao().loadAccount(account);
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        int transactionIndex = this.getNumberOfTransactions(reloadedAccount);
        int newBalance = BoxesRunTime.unboxToInt((Object)reloadedAccount.currentBalance().toRepresentation()) + this.getSignedAmount(transaction);
        this.jdbcTemplate.getJdbcOperations().update(new PreparedStatementCreator(this, transaction, reloadedAccount, transactionIndex, newBalance){
            private final Transaction transaction$1;
            private final Account reloadedAccount$1;
            private final int transactionIndex$1;
            private final int newBalance$1;

            /*
             * WARNING - void declaration
             */
            public PreparedStatement createPreparedStatement(Connection conn) throws SQLException {
                void var3_3;
                String sql = "INSERT INTO Transactions (accountId, index, amount, isCredit, isReconciled, transactionDate, accountBalance) VALUES (?, ?, ?, ?, ?, ?, ?)";
                PreparedStatement ps = conn.prepareStatement(sql, (String[])((Object[])new String[]{"id"}));
                ps.setInt(1, this.reloadedAccount$1.id());
                ps.setInt(2, this.transactionIndex$1);
                ps.setInt(3, BoxesRunTime.unboxToInt((Object)this.transaction$1.amount().toRepresentation()));
                Enumeration.Value value = this.transaction$1.isCredit();
                Enumeration.Value value2 = CreditDebit$.MODULE$.Credit();
                ps.setBoolean(4, !(value != null ? !value.equals(value2) : value2 != null));
                Enumeration.Value value3 = this.transaction$1.isReconciled();
                Enumeration.Value value4 = Reconciled$.MODULE$.Reconciled();
                ps.setBoolean(5, !(value3 != null ? !value3.equals(value4) : value4 != null));
                ps.setDate(6, this.transaction$1.transactionDate().toRepresentation());
                ps.setInt(7, this.newBalance$1);
                return var3_3;
            }
            {
                this.transaction$1 = transaction$1;
                this.reloadedAccount$1 = reloadedAccount$1;
                this.transactionIndex$1 = transactionIndex$1;
                this.newBalance$1 = newBalance$1;
            }
        }, (KeyHolder)keyHolder);
        int key = keyHolder.getKey().intValue();
        Transaction savedTransaction = new Transaction(key, reloadedAccount.id(), new Index(transactionIndex), transaction.amount(), transaction.isCredit(), transaction.isReconciled(), transaction.transactionDate(), new AccountBalance(newBalance));
        Account newBalanceAccount = new Account(reloadedAccount.id(), reloadedAccount.name(), reloadedAccount.withBank(), reloadedAccount.accountCode(), reloadedAccount.initialBalance(), new CurrentBalance(newBalance));
        Account updatedAccount = this.accountsDao().updateAccount(newBalanceAccount);
        return new Tuple2((Object)updatedAccount, (Object)savedTransaction);
    }

    private int getSignedAmount(Transaction transaction) {
        Enumeration.Value value = transaction.isCredit();
        Enumeration.Value value2 = CreditDebit$.MODULE$.Credit();
        return !(value != null ? !value.equals(value2) : value2 != null) ? BoxesRunTime.unboxToInt((Object)transaction.amount().toRepresentation()) : -1 * BoxesRunTime.unboxToInt((Object)transaction.amount().toRepresentation());
    }

    private Object createTransactionMapper() {
        return new ParameterizedRowMapper<Transaction>(this){

            public Transaction mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new Transaction(rs.getInt("id"), rs.getInt("accountId"), new Index(rs.getInt("index")), new Amount(rs.getInt("amount")), rs.getBoolean("isCredit") ? CreditDebit$.MODULE$.Credit() : CreditDebit$.MODULE$.Debit(), rs.getBoolean("isReconciled") ? Reconciled$.MODULE$.Reconciled() : Reconciled$.MODULE$.NotReconciled(), NormalisedDate$.MODULE$.nonNormalisedDate2NormalisedDate(rs.getDate("transactionDate")), new AccountBalance(rs.getInt("accountBalance")));
            }
        };
    }

    public JdbcTemplateTransactionsDao(SimpleJdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.accountsDao = null;
    }
}

