/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.date.UniPeriod;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.entity.DTaskInfo;
import org.devocative.demeter.entity.DTaskSchedule;
import org.devocative.demeter.filter.CollectionUtil;
import org.devocative.demeter.iservice.ApplicationLifecyclePriority;
import org.devocative.demeter.iservice.IApplicationLifecycle;
import org.devocative.demeter.iservice.IDemeterCoreService;
import org.devocative.demeter.iservice.IRequestLifecycle;
import org.devocative.demeter.iservice.IRequestService;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.iservice.task.DTask;
import org.devocative.demeter.iservice.task.DTaskResult;
import org.devocative.demeter.iservice.task.ITaskResultCallback;
import org.devocative.demeter.iservice.task.ITaskResultEvent;
import org.devocative.demeter.iservice.task.ITaskService;
import org.devocative.demeter.service.DTaskScheduleJob;
import org.devocative.demeter.vo.DTaskVO;
import org.devocative.demeter.vo.core.DModuleInfoVO;
import org.devocative.demeter.vo.core.DTaskInfoVO;
import org.devocative.demeter.vo.filter.DTaskFVO;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtTaskService")
public class TaskService
implements ITaskService,
IApplicationLifecycle,
RejectedExecutionHandler,
ITaskResultEvent {
    private static final Logger logger = LoggerFactory.getLogger(TaskService.class);
    private boolean enabled;
    private final Map<String, DTask> TASKS = new ConcurrentHashMap<String, DTask>();
    private Scheduler scheduler;
    private ThreadPoolExecutor threadPoolExecutor;
    private Map<String, IRequestLifecycle> requestLifecycleBeans;
    private Collection<DTaskVO> FINISHED;
    @Autowired
    private ISecurityService securityService;
    @Autowired
    private IPersistorService persistorService;
    @Autowired
    private IDemeterCoreService demeterCoreService;
    @Autowired
    private IRequestService requestService;

    public void init() {
        this.enabled = ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.TaskEnabled);
        logger.info("TaskService.init(): enabled={}", (Object)this.enabled);
        if (!this.enabled) {
            return;
        }
        this.persistorService.startTrx();
        ArrayList<Long> validIds = new ArrayList<Long>();
        List modules = this.demeterCoreService.getModules();
        for (DModuleInfoVO xModule : modules) {
            if (xModule.getTasks() == null) continue;
            for (DTaskInfoVO xdTask : xModule.getTasks()) {
                try {
                    Class<?> beanType = Class.forName(xdTask.getType());
                    this.demeterCoreService.getBean(beanType);
                }
                catch (ClassNotFoundException e) {
                    throw new DSystemException("Unknown task type as bean: " + xdTask.getType());
                }
                DTaskInfo dTaskInfo = this.addOrUpdateTask(xModule.getShortName().toLowerCase(), xdTask);
                validIds.add(dTaskInfo.getId());
            }
        }
        Long count = (Long)this.persistorService.createQueryBuilder().addSelect("select count(1) from DTaskInfo").object();
        if ((long)validIds.size() < count) {
            int noOfDisables = this.persistorService.createQueryBuilder().addSelect("update DTaskInfo ent set ent.enabled = false where ent.id not in (:validIds)").addParam("validIds", validIds).update();
            logger.warn("DTaskInfo are disabled: count=[{}] dbAffect=[{}]", (Object)(count - (long)validIds.size()), (Object)noOfDisables);
        }
        this.persistorService.commitOrRollback();
        this.requestLifecycleBeans = this.demeterCoreService.getBeansOfType(IRequestLifecycle.class);
        this.threadPoolExecutor = new DemeterThreadPoolExecutor((int)ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.TaskPoolSize), ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.TaskPoolMax), ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.TaskPoolAliveTime).intValue(), TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
        this.threadPoolExecutor.setRejectedExecutionHandler(this);
        logger.info("TaskService.init(): ThreadPoolExecutor Up!");
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
            this.scheduler.start();
            logger.info("TaskService.init(): Scheduler Up!");
        }
        catch (SchedulerException e) {
            logger.error("TaskService.init(): StdSchedulerFactory: ", (Throwable)e);
            throw new DSystemException("TaskService.init(): StdSchedulerFactory", (Throwable)e);
        }
        List list = this.persistorService.createQueryBuilder().addFrom(DTaskSchedule.class, "ent").addWhere("and ent.enabled = true and ent.task.enabled = true").list();
        for (DTaskSchedule schedule : list) {
            this.schedule(schedule);
        }
        this.FINISHED = Collections.synchronizedCollection(new CircularFifoQueue(ConfigUtil.getInteger((IConfigKey)DemeterConfigKey.TaskFinishedQueueSize).intValue()));
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        this.stopAll();
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException e) {
            logger.warn("Scheduler Shutdown:", (Throwable)e);
        }
        this.threadPoolExecutor.shutdown();
    }

    public ApplicationLifecyclePriority getLifecyclePriority() {
        return ApplicationLifecyclePriority.Third;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        logger.error("*** TaskService.RejectedExecution: {}", (Object)r);
    }

    public DTaskInfo load(Long id) {
        return (DTaskInfo)this.persistorService.get(DTaskInfo.class, (Serializable)id);
    }

    public DTaskInfo loadByType(String type) {
        return (DTaskInfo)this.persistorService.createQueryBuilder().addFrom(DTaskInfo.class, "ent").addWhere("and ent.type = :type").addParam("type", (Object)type).object();
    }

    public List<DTaskInfo> search(long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addFrom(DTaskInfo.class, "ent").list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count() {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(DTaskInfo.class, "ent").object();
    }

    public DTaskResult start(Class<? extends DTask> taskBeanClass, Object inputData, ITaskResultCallback resultCallback) {
        return this.start(taskBeanClass, null, inputData, resultCallback);
    }

    public DTaskResult start(Class<? extends DTask> taskBeanClass, Object id, Object inputData, ITaskResultCallback resultCallback) {
        if (!this.enabled) {
            throw new DSystemException("Task handling is not enabled");
        }
        logger.info("Starting Task: class=[{}] - id=[{}] - inputData=[{}]", new Object[]{taskBeanClass, id, inputData});
        return this.start(this.loadByType(taskBeanClass.getName()), id, inputData, resultCallback);
    }

    public DTaskResult start(Long taskInfoId, Object id, Object inputData, ITaskResultCallback resultCallback) {
        if (!this.enabled) {
            throw new DSystemException("Task handling is not enabled");
        }
        return this.start(this.load(taskInfoId), id, inputData, resultCallback);
    }

    public void stop(Class<? extends DTask> taskBeanClass, Object id) {
        String key = taskBeanClass.getName();
        if (id != null) {
            key = key + "_" + id;
        }
        this.stop(key);
    }

    public void stop(String key) {
        if (this.TASKS.containsKey(key)) {
            try {
                this.TASKS.get(key).stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("DTask Not Found: " + key);
        }
    }

    public void stopAll() {
        logger.info("TaskService.Shutdown: Running Tasks Count=[{}]", (Object)this.TASKS.size());
        for (DTask dTask : this.TASKS.values()) {
            try {
                dTask.stop();
            }
            catch (Exception e) {
                logger.error("TaskService.Shutdown: id=[{}] key=[{}]", new Object[]{dTask.getId(), dTask.getKey(), e});
            }
        }
    }

    public List<DTaskVO> search(DTaskFVO dTaskFVO, long pageIndex, long pageSize) {
        List dTaskVOs = CollectionUtil.filterCollection(this.getTaskInstances(), (Object)dTaskFVO, (String[])new String[0]);
        int toIndex = (int)(pageIndex * pageSize);
        return dTaskVOs.subList((int)((pageIndex - 1L) * pageIndex), Math.min(toIndex, dTaskVOs.size()));
    }

    public long count(DTaskFVO dTaskFVO) {
        return CollectionUtil.filterCollection(this.getTaskInstances(), (Object)dTaskFVO, (String[])new String[0]).size();
    }

    public void attachToCallback(String key, ITaskResultCallback callback) {
        List list;
        if (this.TASKS.containsKey(key)) {
            list = this.TASKS.get(key).getResultCallbacks();
            if (list.contains(callback)) {
                throw new RuntimeException("Already Attached Callback Handler");
            }
        } else {
            throw new RuntimeException("Invalid key of DTask");
        }
        list.add(callback);
        logger.info("Attach to Task Result: {}", (Object)key);
    }

    public void detachFromCallback(String key, ITaskResultCallback callback) {
        if (this.TASKS.containsKey(key)) {
            List list = this.TASKS.get(key).getResultCallbacks();
            boolean result = list.remove(callback);
            if (!result) {
                throw new RuntimeException("Already Detached Callback Handler");
            }
        } else {
            throw new RuntimeException("Invalid key of DTask");
        }
        logger.info("Detach from Task Result: {}", (Object)key);
    }

    public void onTaskResult(DTask<?> dTask, Object result) {
        this.securityService.authenticate(dTask.getCurrentUser());
        for (ITaskResultCallback callback : dTask.getResultCallbacks()) {
            try {
                callback.onTaskResult(dTask.getId(), result);
            }
            catch (Exception e) {
                callback.onTaskError(dTask.getId(), e);
            }
        }
        this.securityService.authenticate(dTask.getCurrentUser());
    }

    public void onTaskError(DTask<?> dTask, Exception e) {
        this.securityService.authenticate(dTask.getCurrentUser());
        for (ITaskResultCallback callback : dTask.getResultCallbacks()) {
            try {
                callback.onTaskError(dTask.getId(), e);
            }
            catch (Exception e1) {
                logger.error("TaskService.onTaskError: dTask={}", dTask, (Object)e1);
            }
        }
        this.securityService.authenticate(dTask.getCurrentUser());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DTaskVO> getTaskInstances() {
        ArrayList<DTaskVO> result = new ArrayList<DTaskVO>(this.TASKS.size());
        this.TASKS.values().forEach(dTask -> result.add(this.createFromDTask((DTask)dTask)));
        try {
            Collection<DTaskVO> collection = this.FINISHED;
            synchronized (collection) {
                result.addAll(this.FINISHED);
            }
        }
        catch (Exception e) {
            logger.warn("getTaskInstances.Finished", (Throwable)e);
        }
        return result;
    }

    private DTaskResult start(DTaskInfo taskInfo, Object id, Object inputData, ITaskResultCallback resultCallback) {
        if (taskInfo.getEnabled().booleanValue()) {
            try {
                Class<?> taskClass = Class.forName(taskInfo.getType());
                logger.info("Starting Task: class=[{}] - taskInfo=[{}]", taskClass, (Object)taskInfo.getId());
                DTask dTask = (DTask)this.demeterCoreService.getBean(taskClass);
                return this.startDTask(dTask, id, inputData, resultCallback);
            }
            catch (ClassNotFoundException e) {
                logger.error("Can't find task class: class=[{}] taskInfo=[{}]", (Object)taskInfo.getType(), (Object)taskInfo.getId());
                throw new RuntimeException(e);
            }
        }
        logger.warn("Executing disabled task: {}", (Object)taskInfo.getType());
        return null;
    }

    private DTaskResult startDTask(DTask dTask, Object id, Object inputData, ITaskResultCallback resultCallback) {
        if (id == null) {
            id = String.valueOf(System.currentTimeMillis());
        }
        dTask.setId(id).setInputData(inputData).setTaskResultEvent((ITaskResultEvent)this).addTaskResultCallback(resultCallback).setCurrentUser(this.securityService.getCurrentUser()).setCurrentRequest(this.requestService.getCurrentRequest());
        Future<?> result = null;
        if (this.TASKS.containsKey(dTask.getKey())) {
            logger.warn("ReRunning Task: {}", (Object)dTask.getKey());
        } else {
            this.TASKS.put(dTask.getKey(), dTask);
            result = this.threadPoolExecutor.submit((Runnable)dTask);
            logger.info("Started Task: {}", (Object)dTask.getKey());
        }
        return new DTaskResult(result, dTask);
    }

    private DTaskInfo addOrUpdateTask(String module, DTaskInfoVO xdTask) {
        DTaskInfo dTaskInfo = (DTaskInfo)this.persistorService.createQueryBuilder().addFrom(DTaskInfo.class, "ent").addWhere("and ent.type = :type").addParam("type", (Object)xdTask.getType()).object();
        if (dTaskInfo == null) {
            dTaskInfo = new DTaskInfo();
            dTaskInfo.setType(xdTask.getType());
            dTaskInfo.setModule(module);
            this.persistorService.saveOrUpdate((Object)dTaskInfo);
        }
        if (xdTask.getCronExpression() != null) {
            DTaskSchedule schedule = (DTaskSchedule)this.persistorService.createQueryBuilder().addSelect("from DTaskSchedule ent").addWhere("and ent.refId is null").addWhere("and ent.task.id = :taskId").addParam("taskId", (Object)dTaskInfo.getId()).object();
            if (schedule == null) {
                schedule = new DTaskSchedule();
                schedule.setTask(dTaskInfo);
            }
            schedule.setCronExpression(xdTask.getCronExpression());
            this.persistorService.saveOrUpdate((Object)schedule);
        }
        return dTaskInfo;
    }

    private void schedule(DTaskSchedule taskSchedule) {
        String jobKey = taskSchedule.getId().toString();
        logger.info("DTaskSchedule: scheduling: {}", (Object)jobKey);
        JobDataMap map = new JobDataMap();
        map.put("CORE_SERVICE", (Object)this.demeterCoreService);
        JobDetail job = JobBuilder.newJob(DTaskScheduleJob.class).withIdentity(JobKey.jobKey((String)jobKey)).setJobData(map).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)taskSchedule.getCronExpression())).forJob(job).startNow().build();
        try {
            this.scheduler.scheduleJob(job, trigger);
            logger.info("DTaskSchedule: scheduled: {}", (Object)jobKey);
        }
        catch (SchedulerException e) {
            logger.error("TaskService.schedule(): " + jobKey, (Throwable)e);
        }
    }

    private DTaskVO createFromDTask(DTask dTask) {
        DTaskVO dTaskVO = new DTaskVO(dTask.getId().toString(), dTask.getClass().getName(), dTask.getStartDate(), dTask.getState(), dTask.getDetail(), dTask.getCurrentUser().getUsername());
        if (dTask.getDuration() != null) {
            UniPeriod period = UniPeriod.of((long)dTask.getDuration(), (long)0L);
            dTaskVO.setDuration(period.format("H:M:S"));
        }
        return dTaskVO;
    }

    private class DemeterFutureTask<T>
    extends FutureTask<T> {
        private Runnable mainRunnable;

        public DemeterFutureTask(Runnable runnable, T result) {
            super(runnable, result);
            this.mainRunnable = runnable;
        }

        public DTask getDTask() {
            return (DTask)this.mainRunnable;
        }
    }

    private class DemeterThreadPoolExecutor
    extends ThreadPoolExecutor {
        public DemeterThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            DemeterFutureTask futureTask = (DemeterFutureTask)r;
            DTask task = futureTask.getDTask();
            TaskService.this.securityService.authenticate(task.getCurrentUser());
            TaskService.this.requestService.set(task.getCurrentRequest());
            if (TaskService.this.requestLifecycleBeans != null) {
                for (IRequestLifecycle requestLifecycle : TaskService.this.requestLifecycleBeans.values()) {
                    try {
                        logger.debug("Before of TaskService.ThreadPoolExecutor.beforeRequest(): bean = {}", (Object)requestLifecycle.getClass().getName());
                        requestLifecycle.beforeRequest();
                    }
                    catch (Exception e) {
                        logger.error("TaskService.ThreadPoolExecutor.beforeRequest(): bean = {}", (Object)requestLifecycle.getClass().getName(), (Object)e);
                    }
                }
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            DemeterFutureTask futureTask = (DemeterFutureTask)r;
            DTask dTask = futureTask.getDTask();
            logger.info("Task finished: key=[{}], state=[{}], duration=[{}]", new Object[]{dTask.getKey(), dTask.getState(), dTask.getDuration()});
            TaskService.this.TASKS.remove(dTask.getKey());
            if (TaskService.this.requestLifecycleBeans != null) {
                for (IRequestLifecycle requestLifecycle : TaskService.this.requestLifecycleBeans.values()) {
                    try {
                        logger.debug("Before of TaskService.ThreadPoolExecutor.afterResponse(): bean = {}", (Object)requestLifecycle.getClass().getName());
                        requestLifecycle.afterResponse();
                    }
                    catch (Exception e) {
                        logger.error("TaskService.ThreadPoolExecutor.afterResponse(): bean = {}", (Object)requestLifecycle.getClass().getName(), (Object)e);
                    }
                }
            }
            TaskService.this.requestService.unset();
            try {
                TaskService.this.FINISHED.add(TaskService.this.createFromDTask(dTask));
            }
            catch (Exception e) {
                logger.warn("DemeterThreadPoolExecutor.afterExecute, adding to FINISHED", (Throwable)e);
            }
        }

        @Override
        protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
            return new DemeterFutureTask<T>(runnable, value);
        }
    }
}

