/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import org.devocative.demeter.entity.DTaskSchedule;
import org.devocative.demeter.iservice.IDemeterCoreService;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.iservice.task.ITaskService;
import org.devocative.demeter.vo.UserVO;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTaskScheduleJob
implements Job {
    private static Logger logger = LoggerFactory.getLogger(DTaskScheduleJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        String scheduleId = context.getJobDetail().getKey().getName();
        logger.info("DTaskScheduleJob: scheduleId={}", (Object)scheduleId);
        IDemeterCoreService demeterCoreService = (IDemeterCoreService)context.getMergedJobDataMap().get((Object)"CORE_SERVICE");
        IPersistorService persistorService = (IPersistorService)demeterCoreService.getBean("dmtPersistorService");
        ITaskService taskService = (ITaskService)demeterCoreService.getBean(ITaskService.class);
        ISecurityService securityService = (ISecurityService)demeterCoreService.getBean(ISecurityService.class);
        UserVO currentUser = securityService.getCurrentUser();
        if (currentUser == null) {
            securityService.authenticate(securityService.getSystemUser());
        }
        try {
            DTaskSchedule schedule = (DTaskSchedule)persistorService.get(DTaskSchedule.class, (Serializable)new Long(scheduleId));
            if (schedule.getEnabled().booleanValue()) {
                taskService.start(schedule.getTask().getId(), null, (Object)schedule.getRefId(), null);
            }
        }
        catch (Exception e) {
            logger.error("DemeterSimpleTaskJob: schedule=" + scheduleId, (Throwable)e);
        }
        finally {
            persistorService.endSession();
        }
    }
}

