/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.devocative.adroit.ConfigUtil;
import org.devocative.adroit.IConfigKey;
import org.devocative.adroit.cache.ICache;
import org.devocative.demeter.DSystemException;
import org.devocative.demeter.DemeterConfigKey;
import org.devocative.demeter.entity.DPageInfo;
import org.devocative.demeter.entity.DPageInstance;
import org.devocative.demeter.entity.Role;
import org.devocative.demeter.entity.User;
import org.devocative.demeter.iservice.ApplicationLifecyclePriority;
import org.devocative.demeter.iservice.IApplicationLifecycle;
import org.devocative.demeter.iservice.ICacheService;
import org.devocative.demeter.iservice.IDPageInstanceService;
import org.devocative.demeter.iservice.IDemeterCoreService;
import org.devocative.demeter.iservice.IRoleService;
import org.devocative.demeter.iservice.persistor.EJoinMode;
import org.devocative.demeter.iservice.persistor.IPersistorService;
import org.devocative.demeter.iservice.persistor.IQueryBuilder;
import org.devocative.demeter.vo.UserVO;
import org.devocative.demeter.vo.core.DModuleInfoVO;
import org.devocative.demeter.vo.core.DPageInfoVO;
import org.devocative.demeter.vo.filter.DPageInstanceFVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtDPageInstanceService")
public class DPageInstanceService
implements IDPageInstanceService,
IApplicationLifecycle {
    private static final Logger logger = LoggerFactory.getLogger(DPageInstanceService.class);
    private ICache<String, DPageInstance> pageInstCache;
    private ICache<Class, String> uriCache;
    private Map<Long, DPageInfoVO> pageInfoId_2_DPageInfoVO = new HashMap<Long, DPageInfoVO>();
    @Autowired
    private IPersistorService persistorService;
    @Autowired
    private IDemeterCoreService demeterCoreService;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private IRoleService roleService;

    public void saveOrUpdate(DPageInstance entity) {
        this.persistorService.saveOrUpdate((Object)entity);
    }

    public DPageInstance load(Long id) {
        return (DPageInstance)this.persistorService.get(DPageInstance.class, (Serializable)id);
    }

    public DPageInstance loadByUri(String uri) {
        return (DPageInstance)this.persistorService.createQueryBuilder().addFrom(DPageInstance.class, "ent").addWhere("and ent.uri = :uri", "uri", (Object)uri).object();
    }

    public List<DPageInstance> list() {
        return this.persistorService.list(DPageInstance.class);
    }

    public List<DPageInstance> search(DPageInstanceFVO filter, long pageIndex, long pageSize) {
        return this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(DPageInstance.class, "ent").applyFilter(DPageInstance.class, "ent", (Serializable)filter, new String[0]).list((pageIndex - 1L) * pageSize, pageSize);
    }

    public long count(DPageInstanceFVO filter) {
        return (Long)this.persistorService.createQueryBuilder().addSelect("select count(1)").addFrom(DPageInstance.class, "ent").applyFilter(DPageInstance.class, "ent", (Serializable)filter, new String[0]).object();
    }

    public List<DPageInfo> getPageInfoList() {
        return this.persistorService.list(DPageInfo.class);
    }

    public List<Role> getRolesList() {
        return this.persistorService.list("from Role ent order by ent.name");
    }

    public List<User> getCreatorUserList() {
        return this.persistorService.list(User.class);
    }

    public List<User> getModifierUserList() {
        return this.persistorService.list(User.class);
    }

    public void init() {
        this.persistorService.startTrx();
        int totalDPageSize = 0;
        ArrayList<Long> validIds = new ArrayList<Long>();
        List modules = this.demeterCoreService.getModules();
        for (DModuleInfoVO dModule : modules) {
            List dPages = dModule.getDPages();
            if (dPages == null) continue;
            for (DPageInfoVO dPage : dPages) {
                DPageInfo pageInfo = this.addOrUpdatePageInfo(dModule.getShortName().toLowerCase(), dPage);
                validIds.add(pageInfo.getId());
                this.pageInfoId_2_DPageInfoVO.put(pageInfo.getId(), dPage);
            }
            totalDPageSize += dPages.size();
        }
        Long count = (Long)this.persistorService.createQueryBuilder().addSelect("select count(1) from DPageInfo").object();
        if ((long)validIds.size() < count) {
            int noOfDisables = this.persistorService.createQueryBuilder().addSelect("update DPageInfo ent set ent.enabled = false where ent.id not in (:validIds)").addParam("validIds", validIds).update();
            logger.warn("DPageInfo are disabled: count=[{}] dbAffect=[{}]", (Object)(count - (long)validIds.size()), (Object)noOfDisables);
        }
        this.persistorService.commitOrRollback();
        this.pageInstCache = this.cacheService.create("DMT_D_PAGE_INST", totalDPageSize * 2, key -> (DPageInstance)this.persistorService.createQueryBuilder().addFrom(DPageInstance.class, "ent").addWhere("and ent.uri = :uri", "uri", key).object());
        this.uriCache = this.cacheService.create("DMT_D_PAGE_URI", totalDPageSize * 2, key -> {
            DPageInfo pageInfo = (DPageInfo)this.persistorService.createQueryBuilder().addFrom(DPageInfo.class, "ent").addWhere("and (ent.type = :type or ent.typeAlt = :type)", "type", (Object)key.getName()).object();
            if (pageInfo != null) {
                return pageInfo.getBaseUri();
            }
            return "";
        });
    }

    public void shutdown() {
    }

    public ApplicationLifecyclePriority getLifecyclePriority() {
        return ApplicationLifecyclePriority.Third;
    }

    public DPageInstance getPageInstanceByURI(String uri, String refIdParam) {
        String uri2;
        if (refIdParam != null && this.pageInstCache.containsKeyOrFetch((Object)(uri2 = uri + "/" + refIdParam))) {
            return (DPageInstance)this.pageInstCache.get((Object)uri2);
        }
        return (DPageInstance)this.pageInstCache.get((Object)uri);
    }

    public UserVO.PageVO getDefaultPages() {
        List instances = this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(DPageInstance.class, "ent").addJoin("dp", "ent.pageInfo", EJoinMode.LeftFetch).addWhere("and dp.enabled = true").addWhere("and ent.inMenu = true").list();
        HashSet<String> accessibleUri = new HashSet<String>();
        HashMap menuEntries = new HashMap();
        for (DPageInstance pageInstance : instances) {
            String module;
            DPageInfo pageInfo = pageInstance.getPageInfo();
            if (this.pageInfoId_2_DPageInfoVO.containsKey(pageInfo.getId())) {
                pageInstance.setIcon(this.pageInfoId_2_DPageInfoVO.get(pageInfo.getId()).getIcon());
            }
            if (!menuEntries.containsKey(module = pageInfo.getModule())) {
                menuEntries.put(module, new LinkedHashSet());
            }
            ((Set)menuEntries.get(module)).add(pageInstance);
            accessibleUri.add(pageInstance.getUri());
        }
        return new UserVO.PageVO(accessibleUri, menuEntries);
    }

    public String getUriByPage(Class dPageClass) {
        return (String)this.uriCache.get((Object)dPageClass);
    }

    public UserVO.PageVO getAccessiblePages(Collection<Role> roles) {
        IQueryBuilder queryBuilder = this.persistorService.createQueryBuilder().addSelect("select ent").addFrom(DPageInstance.class, "ent").addJoin("pi", "ent.pageInfo", EJoinMode.LeftFetch).addJoin("rl", "ent.roles", EJoinMode.Left).addWhere("and pi.enabled = true");
        if (roles != null && !roles.isEmpty()) {
            queryBuilder.addWhere("and (rl in (:roles) or rl.id is null)", "roles", roles);
        } else {
            queryBuilder.addWhere("and rl.id is null");
        }
        List instances = queryBuilder.list();
        HashSet<String> accessibleUri = new HashSet<String>();
        HashMap menuEntries = new HashMap();
        for (DPageInstance pageInstance : instances) {
            DPageInfo pageInfo = pageInstance.getPageInfo();
            if (this.pageInfoId_2_DPageInfoVO.containsKey(pageInfo.getId())) {
                pageInstance.setIcon(this.pageInfoId_2_DPageInfoVO.get(pageInfo.getId()).getIcon());
            }
            String module = pageInfo.getModule();
            if (pageInstance.getInMenu().booleanValue()) {
                if (!menuEntries.containsKey(module)) {
                    menuEntries.put(module, new LinkedHashSet());
                }
                ((Set)menuEntries.get(module)).add(pageInstance);
            }
            accessibleUri.add(pageInstance.getUri());
        }
        return new UserVO.PageVO(accessibleUri, menuEntries);
    }

    private DPageInfo addOrUpdatePageInfo(String module, DPageInfoVO dPage) {
        String baseUri = dPage.getUri().startsWith("/") ? String.format("/%s%s", module, dPage.getUri()) : String.format("/%s/%s", module, dPage.getUri());
        DPageInfo pageInfo = (DPageInfo)this.persistorService.createQueryBuilder().addFrom(DPageInfo.class, "ent").addWhere("and (ent.type = :type or ent.typeAlt = :type or ent.baseUri = :uri)").addParam("type", (Object)dPage.getType()).addParam("uri", (Object)baseUri).object();
        if (pageInfo == null) {
            pageInfo = new DPageInfo();
            pageInfo.setType(dPage.getType());
        } else if (!pageInfo.getType().equals(dPage.getType())) {
            pageInfo.setTypeAlt(dPage.getType());
        }
        pageInfo.setModule(module);
        pageInfo.setBaseUri(baseUri);
        this.persistorService.saveOrUpdate((Object)pageInfo);
        DPageInstance pageInstance = (DPageInstance)this.persistorService.createQueryBuilder().addFrom(DPageInstance.class, "ent").addWhere("and ent.pageInfo.id = :pageId", "pageId", (Object)pageInfo.getId()).addWhere("and ent.refId is null").object();
        if (pageInstance == null) {
            pageInstance = new DPageInstance();
        }
        if (dPage.getTitle() != null && dPage.getTitle().startsWith("KEY:")) {
            String prefix = String.format("%sdPage.%s.", "KEY:", module);
            if (!dPage.getTitle().startsWith(prefix)) {
                throw new DSystemException("Invalid DPage title key: " + dPage.getTitle());
            }
        }
        pageInstance.setTitle(dPage.getTitle());
        pageInstance.setInMenu(dPage.getInMenu());
        pageInstance.setPageInfo(pageInfo);
        pageInstance.setUri(pageInfo.getBaseUri());
        if (dPage.getRoles() != null && !dPage.getRoles().isEmpty()) {
            String[] roleNames;
            List roles = ConfigUtil.getBoolean((IConfigKey)DemeterConfigKey.DPageInstRolesByXML) != false || pageInstance.getRoles() == null ? new ArrayList() : pageInstance.getRoles();
            for (String roleName : roleNames = dPage.getRoles().split("[,]")) {
                Role role = this.roleService.loadByName(roleName.trim());
                if (role == null) {
                    throw new DSystemException("Role not Found: " + roleName);
                }
                if (roles.contains(role)) continue;
                roles.add(role);
            }
            pageInstance.setRoles(roles);
        }
        this.persistorService.saveOrUpdate((Object)pageInstance);
        return pageInfo;
    }
}

