/*
 * Decompiled with CFR 0.152.
 */
package org.devocative.demeter.service;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.devocative.adroit.cache.ICache;
import org.devocative.adroit.cache.IMissedHitHandler;
import org.devocative.adroit.cache.LRUCache;
import org.devocative.demeter.iservice.ICacheService;
import org.devocative.demeter.iservice.ISecurityService;
import org.devocative.demeter.vo.CacheInfoVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="dmtCacheService")
public class CacheService
implements ICacheService {
    private static final Logger logger = LoggerFactory.getLogger(CacheService.class);
    private final Map<String, ICache<?, ?>> ALL_CACHES = new LinkedHashMap();
    @Autowired
    private ISecurityService securityService;

    public <K, V> ICache<K, V> create(String id, int capacity) {
        return this.create(id, capacity, null);
    }

    public <K, V> ICache<K, V> create(String id, int capacity, IMissedHitHandler<K, V> missedHitHandler) {
        logger.info("ICache created: {}, capacity = {}", (Object)id, (Object)capacity);
        LRUCache cache = new LRUCache(capacity, missedHitHandler);
        this.ALL_CACHES.put(id, (ICache<?, ?>)cache);
        return cache;
    }

    public void clear(String id) {
        if (this.ALL_CACHES.containsKey(id)) {
            logger.warn("ICache cleared: ID=[{}] User=[{}]", (Object)id, (Object)this.securityService.getCurrentUser());
            this.ALL_CACHES.get(id).clear();
        } else {
            logger.warn("Try to clear cache which has not been created: {}", (Object)id);
        }
    }

    public List<CacheInfoVO> list() {
        ArrayList<CacheInfoVO> result = new ArrayList<CacheInfoVO>();
        for (Map.Entry<String, ICache<?, ?>> entry : this.ALL_CACHES.entrySet()) {
            CacheInfoVO vo = new CacheInfoVO().setId(entry.getKey()).setCapacity(entry.getValue().getCapacity()).setSize(entry.getValue().getSize()).setMissHitCount(entry.getValue().getMissHitCount());
            result.add(vo);
        }
        return result;
    }
}

