/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.devlive.sdk.openai.entity.EmbeddingEntity;
import org.devlive.sdk.openai.entity.UsageEntity;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddingResponse {
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="data")
    private List<EmbeddingEntity> embeddings;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="usage")
    private UsageEntity usage;

    public static EmbeddingResponseBuilder builder() {
        return new EmbeddingResponseBuilder();
    }

    public String getObject() {
        return this.object;
    }

    public List<EmbeddingEntity> getEmbeddings() {
        return this.embeddings;
    }

    public String getModel() {
        return this.model;
    }

    public UsageEntity getUsage() {
        return this.usage;
    }

    @JsonProperty(value="object")
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="data")
    public void setEmbeddings(List<EmbeddingEntity> embeddings) {
        this.embeddings = embeddings;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="usage")
    public void setUsage(UsageEntity usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingResponse)) {
            return false;
        }
        EmbeddingResponse other = (EmbeddingResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<EmbeddingEntity> this$embeddings = this.getEmbeddings();
        List<EmbeddingEntity> other$embeddings = other.getEmbeddings();
        if (this$embeddings == null ? other$embeddings != null : !((Object)this$embeddings).equals(other$embeddings)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        UsageEntity this$usage = this.getUsage();
        UsageEntity other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<EmbeddingEntity> $embeddings = this.getEmbeddings();
        result = result * 59 + ($embeddings == null ? 43 : ((Object)$embeddings).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        UsageEntity $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingResponse(object=" + this.getObject() + ", embeddings=" + this.getEmbeddings() + ", model=" + this.getModel() + ", usage=" + this.getUsage() + ")";
    }

    public EmbeddingResponse() {
    }

    public EmbeddingResponse(String object, List<EmbeddingEntity> embeddings, String model, UsageEntity usage) {
        this.object = object;
        this.embeddings = embeddings;
        this.model = model;
        this.usage = usage;
    }

    public static class EmbeddingResponseBuilder {
        private String object;
        private List<EmbeddingEntity> embeddings;
        private String model;
        private UsageEntity usage;

        EmbeddingResponseBuilder() {
        }

        @JsonProperty(value="object")
        public EmbeddingResponseBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="data")
        public EmbeddingResponseBuilder embeddings(List<EmbeddingEntity> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        @JsonProperty(value="model")
        public EmbeddingResponseBuilder model(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="usage")
        public EmbeddingResponseBuilder usage(UsageEntity usage) {
            this.usage = usage;
            return this;
        }

        public EmbeddingResponse build() {
            return new EmbeddingResponse(this.object, this.embeddings, this.model, this.usage);
        }

        public String toString() {
            return "EmbeddingResponse.EmbeddingResponseBuilder(object=" + this.object + ", embeddings=" + this.embeddings + ", model=" + this.model + ", usage=" + this.usage + ")";
        }
    }
}

