/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.response;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.devlive.sdk.openai.choice.ChatChoice;
import org.devlive.sdk.openai.entity.UsageEntity;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatResponse {
    @JsonProperty(value="id")
    private String name;
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="created")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String createTime;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="choices")
    private List<ChatChoice> choices;
    @JsonProperty(value="usage")
    private UsageEntity usage;

    public static ChatResponseBuilder builder() {
        return new ChatResponseBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getObject() {
        return this.object;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getModel() {
        return this.model;
    }

    public List<ChatChoice> getChoices() {
        return this.choices;
    }

    public UsageEntity getUsage() {
        return this.usage;
    }

    @JsonProperty(value="id")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="object")
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="created")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="choices")
    public void setChoices(List<ChatChoice> choices) {
        this.choices = choices;
    }

    @JsonProperty(value="usage")
    public void setUsage(UsageEntity usage) {
        this.usage = usage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatResponse)) {
            return false;
        }
        ChatResponse other = (ChatResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<ChatChoice> this$choices = this.getChoices();
        List<ChatChoice> other$choices = other.getChoices();
        if (this$choices == null ? other$choices != null : !((Object)this$choices).equals(other$choices)) {
            return false;
        }
        UsageEntity this$usage = this.getUsage();
        UsageEntity other$usage = other.getUsage();
        return !(this$usage == null ? other$usage != null : !((Object)this$usage).equals(other$usage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<ChatChoice> $choices = this.getChoices();
        result = result * 59 + ($choices == null ? 43 : ((Object)$choices).hashCode());
        UsageEntity $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : ((Object)$usage).hashCode());
        return result;
    }

    public String toString() {
        return "ChatResponse(name=" + this.getName() + ", object=" + this.getObject() + ", createTime=" + this.getCreateTime() + ", model=" + this.getModel() + ", choices=" + this.getChoices() + ", usage=" + this.getUsage() + ")";
    }

    public ChatResponse() {
    }

    public ChatResponse(String name, String object, String createTime, String model, List<ChatChoice> choices, UsageEntity usage) {
        this.name = name;
        this.object = object;
        this.createTime = createTime;
        this.model = model;
        this.choices = choices;
        this.usage = usage;
    }

    public static class ChatResponseBuilder {
        private String name;
        private String object;
        private String createTime;
        private String model;
        private List<ChatChoice> choices;
        private UsageEntity usage;

        ChatResponseBuilder() {
        }

        @JsonProperty(value="id")
        public ChatResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="object")
        public ChatResponseBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="created")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public ChatResponseBuilder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        @JsonProperty(value="model")
        public ChatResponseBuilder model(String model) {
            this.model = model;
            return this;
        }

        @JsonProperty(value="choices")
        public ChatResponseBuilder choices(List<ChatChoice> choices) {
            this.choices = choices;
            return this;
        }

        @JsonProperty(value="usage")
        public ChatResponseBuilder usage(UsageEntity usage) {
            this.usage = usage;
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this.name, this.object, this.createTime, this.model, this.choices, this.usage);
        }

        public String toString() {
            return "ChatResponse.ChatResponseBuilder(name=" + this.name + ", object=" + this.object + ", createTime=" + this.createTime + ", model=" + this.model + ", choices=" + this.choices + ", usage=" + this.usage + ")";
        }
    }
}

