/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.listener;

import java.time.LocalDateTime;
import java.util.concurrent.CountDownLatch;
import okhttp3.Response;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleEventSourceListener
extends EventSourceListener {
    private static final Logger log = LoggerFactory.getLogger(ConsoleEventSourceListener.class);
    private CountDownLatch countDownLatch;

    public void onOpen(EventSource eventSource, Response response) {
        log.info("Console listener opened on time {}", (Object)LocalDateTime.now());
    }

    public void onClosed(EventSource eventSource) {
        log.info("Console listener closed on time {}", (Object)LocalDateTime.now());
        eventSource.cancel();
        this.close();
    }

    public void onEvent(EventSource eventSource, String id, String type, String data) {
        if (data.equals("[DONE]")) {
            eventSource.cancel();
            this.close();
        } else {
            log.info("Console event received on time {} id {} type {} data {}", new Object[]{LocalDateTime.now(), id, type, data});
        }
    }

    public void onFailure(EventSource eventSource, Throwable throwable, Response response) {
        if (ObjectUtils.isNotEmpty((Object)throwable)) {
            if (throwable.getMessage().endsWith("CANCEL")) {
                log.info("Console listener cancelled on time {}", (Object)LocalDateTime.now());
                this.onClosed(eventSource);
            } else {
                log.error("Console listener throwable \n{}\n response: \n{}\n", (Object)throwable, (Object)response);
            }
        } else {
            log.error("Console listener failure with empty throwable. Response: \n{}\n", (Object)response);
        }
        eventSource.cancel();
        this.close();
    }

    private void close() {
        if (ObjectUtils.isNotEmpty((Object)this.countDownLatch)) {
            this.countDownLatch.countDown();
        }
    }

    ConsoleEventSourceListener(CountDownLatch countDownLatch) {
        this.countDownLatch = countDownLatch;
    }

    public static ConsoleEventSourceListenerBuilder builder() {
        return new ConsoleEventSourceListenerBuilder();
    }

    public static class ConsoleEventSourceListenerBuilder {
        private CountDownLatch countDownLatch;

        ConsoleEventSourceListenerBuilder() {
        }

        public ConsoleEventSourceListenerBuilder countDownLatch(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
            return this;
        }

        public ConsoleEventSourceListener build() {
            return new ConsoleEventSourceListener(this.countDownLatch);
        }

        public String toString() {
            return "ConsoleEventSourceListener.ConsoleEventSourceListenerBuilder(countDownLatch=" + this.countDownLatch + ")";
        }
    }
}

