/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.interceptor;

import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.interceptor.DefaultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAiInterceptor
extends DefaultInterceptor {
    private static final Logger log = LoggerFactory.getLogger(OpenAiInterceptor.class);

    public OpenAiInterceptor() {
        log.debug("OpenAi Interceptor");
    }

    @Override
    public Request prepared(Request original) {
        log.debug("OpenAi interceptor request url {}", (Object)original.url());
        if (StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            throw new ParamException("Invalid OpenAi token, must be non-empty");
        }
        original = original.newBuilder().header("Authorization", String.format("Bearer %s", this.getApiKey())).header("Content-Type", "application/json").method(original.method(), original.body()).build();
        if (this.getExtra() != null) {
            original = original.newBuilder().header("OpenAI-Beta", this.getExtra()).build();
        }
        return original;
    }
}

