/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.interceptor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.interceptor.DefaultInterceptor;
import org.devlive.sdk.openai.model.CompletionModel;
import org.devlive.sdk.openai.utils.EnumsUtils;
import org.devlive.sdk.openai.utils.HttpUrlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GooglePaLMInterceptor
extends DefaultInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GooglePaLMInterceptor.class);

    public GooglePaLMInterceptor() {
        log.debug("Google PaLM Interceptor");
    }

    @Override
    protected Request prepared(Request original) {
        if (StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            throw new ParamException("Invalid Google PaLM token, must be non-empty");
        }
        HttpUrl httpUrl = original.url();
        ArrayList pathSegments = Lists.newArrayList();
        httpUrl = HttpUrlUtils.removePathSegment(httpUrl);
        pathSegments.add(0, String.join((CharSequence)":", this.getModel(), this.getModelType()));
        pathSegments.add(0, "models");
        pathSegments.add(0, "v1beta2");
        httpUrl = httpUrl.newBuilder().host(httpUrl.host()).port(httpUrl.port()).addPathSegments(String.join((CharSequence)"/", pathSegments)).addQueryParameter("key", this.getApiKey()).build();
        log.debug("Google PaLM interceptor request url {}", (Object)httpUrl);
        return original.newBuilder().header("Content-Type", "application/json").url(httpUrl).method(original.method(), original.body()).build();
    }

    private String getModelType() {
        CompletionModel model = EnumsUtils.getCompleteModel(this.getModel());
        switch (model) {
            case TEXT_BISON_001: {
                return "generateText";
            }
            case CHAT_BISON_001: {
                return "generateMessage";
            }
        }
        throw new ParamException("Unsupported Google PaLM model");
    }
}

