/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.interceptor;

import com.google.common.base.Preconditions;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.apache.commons.lang3.ObjectUtils;
import org.devlive.sdk.openai.exception.AuthorizedException;
import org.devlive.sdk.openai.exception.RequestException;
import org.devlive.sdk.openai.response.DefaultResponse;
import org.devlive.sdk.openai.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(DefaultInterceptor.class);
    private String apiKey;
    private String model;
    private String version;
    private String extra;

    protected abstract Request prepared(Request var1);

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        JsonUtils jsonInstance = JsonUtils.getInstance();
        Request original = chain.request();
        Request request = this.prepared(original);
        RequestBody requestBody = request.body();
        if (ObjectUtils.isNotEmpty((Object)requestBody)) {
            Buffer buffer = new Buffer();
            requestBody.writeTo((BufferedSink)buffer);
            log.debug("Request body {}", (Object)buffer.readUtf8());
        }
        if (!(response = chain.proceed(request)).isSuccessful()) {
            log.error("Failed to intercept request");
        }
        if (ObjectUtils.isEmpty((Object)response.body())) {
            log.error("Failure to intercept request because no body");
            Preconditions.checkState((boolean)false, (Object)"Failure to intercept request because no body");
        }
        if (response.code() == 401) {
            ResponseBody body = response.body();
            if (ObjectUtils.isEmpty((Object)body)) {
                throw new NullPointerException("Failed to intercept request because no body");
            }
            DefaultResponse defaultResponse = jsonInstance.getObject(body.string(), DefaultResponse.class);
            log.error("Failure to intercept request because not authorized {}", (Object)defaultResponse.getError().getMessage());
            throw new AuthorizedException(defaultResponse.getError().getMessage());
        }
        if (response.code() == 404 || response.code() == 400 || response.code() == 403 || response.code() == 405) {
            ResponseBody body = response.body();
            if (ObjectUtils.isEmpty((Object)body)) {
                throw new NullPointerException("Failed to intercept request because no body");
            }
            DefaultResponse defaultResponse = jsonInstance.getObject(body.string(), DefaultResponse.class);
            log.error("Failure to intercept request because {}", (Object)defaultResponse.getError().getMessage());
            throw new RequestException(defaultResponse.getError().getMessage());
        }
        return response;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public String getVersion() {
        return this.version;
    }

    public String getExtra() {
        return this.extra;
    }
}

