/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.interceptor;

import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.interceptor.DefaultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClaudeInterceptor
extends DefaultInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ClaudeInterceptor.class);

    public ClaudeInterceptor() {
        log.debug("Claude Interceptor");
    }

    @Override
    protected Request prepared(Request original) {
        log.debug("Claude interceptor request url {}", (Object)original.url());
        if (StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            throw new ParamException("Invalid Claude token, must be non-empty");
        }
        return original.newBuilder().header("x-api-key", this.getApiKey()).header("Content-Type", "application/json").method(original.method(), original.body()).build();
    }
}

