/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.interceptor;

import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.Request;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.interceptor.DefaultInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureInterceptor
extends DefaultInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AzureInterceptor.class);

    public AzureInterceptor() {
        log.debug("Azure Interceptor");
    }

    @Override
    protected Request prepared(Request original) {
        HttpUrl httpUrl = original.url();
        List pathSegments = httpUrl.pathSegments();
        httpUrl = this.removePathSegment(httpUrl);
        pathSegments.add(0, this.getModel());
        pathSegments.add(0, "deployments");
        pathSegments.add(0, "openai");
        httpUrl = httpUrl.newBuilder().host(httpUrl.host()).port(httpUrl.port()).addPathSegments(String.join((CharSequence)"/", pathSegments)).addQueryParameter("api-version", this.getVersion()).build();
        log.debug("Azure interceptor request url {}", (Object)httpUrl.toString());
        if (StringUtils.isEmpty((CharSequence)this.getApiKey())) {
            throw new ParamException("Invalid OpenAi token, must be non-empty");
        }
        return original.newBuilder().header("api-key", this.getApiKey()).header("Content-Type", "application/json").url(httpUrl).method(original.method(), original.body()).build();
    }

    private HttpUrl removePathSegment(HttpUrl httpUrl) {
        List pathSegments = httpUrl.pathSegments();
        for (int i = 0; i < pathSegments.size(); ++i) {
            httpUrl = httpUrl.newBuilder().removePathSegment(0).build();
        }
        return httpUrl;
    }
}

