/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity.google;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.devlive.sdk.openai.entity.google.PromptEntity;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatEntity {
    @JsonProperty(value="prompt")
    private PromptEntity prompt;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_k")
    private Integer topK;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="candidate_count")
    private Integer candidateCount;

    private static Double $default$temperature() {
        return 0.25;
    }

    private static Integer $default$topK() {
        return 40;
    }

    private static Double $default$topP() {
        return 1.0;
    }

    private static Integer $default$candidateCount() {
        return 1;
    }

    public static ChatEntityBuilder builder() {
        return new ChatEntityBuilder();
    }

    public PromptEntity getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getTopK() {
        return this.topK;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getCandidateCount() {
        return this.candidateCount;
    }

    @JsonProperty(value="prompt")
    public void setPrompt(PromptEntity prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_k")
    public void setTopK(Integer topK) {
        this.topK = topK;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="candidate_count")
    public void setCandidateCount(Integer candidateCount) {
        this.candidateCount = candidateCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatEntity)) {
            return false;
        }
        ChatEntity other = (ChatEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$topK = this.getTopK();
        Integer other$topK = other.getTopK();
        if (this$topK == null ? other$topK != null : !((Object)this$topK).equals(other$topK)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$candidateCount = this.getCandidateCount();
        Integer other$candidateCount = other.getCandidateCount();
        if (this$candidateCount == null ? other$candidateCount != null : !((Object)this$candidateCount).equals(other$candidateCount)) {
            return false;
        }
        PromptEntity this$prompt = this.getPrompt();
        PromptEntity other$prompt = other.getPrompt();
        return !(this$prompt == null ? other$prompt != null : !((Object)this$prompt).equals(other$prompt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $topK = this.getTopK();
        result = result * 59 + ($topK == null ? 43 : ((Object)$topK).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $candidateCount = this.getCandidateCount();
        result = result * 59 + ($candidateCount == null ? 43 : ((Object)$candidateCount).hashCode());
        PromptEntity $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)$prompt).hashCode());
        return result;
    }

    public String toString() {
        return "ChatEntity(prompt=" + this.getPrompt() + ", temperature=" + this.getTemperature() + ", topK=" + this.getTopK() + ", topP=" + this.getTopP() + ", candidateCount=" + this.getCandidateCount() + ")";
    }

    public ChatEntity(PromptEntity prompt, Double temperature, Integer topK, Double topP, Integer candidateCount) {
        this.prompt = prompt;
        this.temperature = temperature;
        this.topK = topK;
        this.topP = topP;
        this.candidateCount = candidateCount;
    }

    public static class ChatEntityBuilder {
        private PromptEntity prompt;
        private boolean temperature$set;
        private Double temperature$value;
        private boolean topK$set;
        private Integer topK$value;
        private boolean topP$set;
        private Double topP$value;
        private boolean candidateCount$set;
        private Integer candidateCount$value;

        ChatEntityBuilder() {
        }

        @JsonProperty(value="prompt")
        public ChatEntityBuilder prompt(PromptEntity prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="temperature")
        public ChatEntityBuilder temperature(Double temperature) {
            this.temperature$value = temperature;
            this.temperature$set = true;
            return this;
        }

        @JsonProperty(value="top_k")
        public ChatEntityBuilder topK(Integer topK) {
            this.topK$value = topK;
            this.topK$set = true;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatEntityBuilder topP(Double topP) {
            this.topP$value = topP;
            this.topP$set = true;
            return this;
        }

        @JsonProperty(value="candidate_count")
        public ChatEntityBuilder candidateCount(Integer candidateCount) {
            this.candidateCount$value = candidateCount;
            this.candidateCount$set = true;
            return this;
        }

        public ChatEntity build() {
            Double temperature$value = this.temperature$value;
            if (!this.temperature$set) {
                temperature$value = ChatEntity.$default$temperature();
            }
            Integer topK$value = this.topK$value;
            if (!this.topK$set) {
                topK$value = ChatEntity.$default$topK();
            }
            Double topP$value = this.topP$value;
            if (!this.topP$set) {
                topP$value = ChatEntity.$default$topP();
            }
            Integer candidateCount$value = this.candidateCount$value;
            if (!this.candidateCount$set) {
                candidateCount$value = ChatEntity.$default$candidateCount();
            }
            return new ChatEntity(this.prompt, temperature$value, topK$value, topP$value, candidateCount$value);
        }

        public String toString() {
            return "ChatEntity.ChatEntityBuilder(prompt=" + this.prompt + ", temperature$value=" + this.temperature$value + ", topK$value=" + this.topK$value + ", topP$value=" + this.topP$value + ", candidateCount$value=" + this.candidateCount$value + ")";
        }
    }
}

