/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity.beta;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.CompletionModel;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AssistantsEntity {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="instructions")
    private String instructions;
    @JsonProperty(value="tools")
    private Set<Map<String, String>> tools = Sets.newHashSet();
    @JsonProperty(value="file_ids")
    private Set<String> fileIds = Sets.newHashSet();
    @JsonProperty(value="metadata")
    private Map<String, String> metadata;

    public AssistantsEntity(AssistantsEntityBuilder builder) {
        this.model = builder.model;
        this.name = builder.name;
        this.description = builder.description;
        this.instructions = builder.instructions;
        this.tools = builder.tools;
        this.fileIds = builder.fileIds;
        this.metadata = builder.metadata;
    }

    public static AssistantsEntityBuilder builder() {
        return new AssistantsEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public Set<Map<String, String>> getTools() {
        return this.tools;
    }

    public Set<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="instructions")
    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    @JsonProperty(value="tools")
    public void setTools(Set<Map<String, String>> tools) {
        this.tools = tools;
    }

    @JsonProperty(value="file_ids")
    public void setFileIds(Set<String> fileIds) {
        this.fileIds = fileIds;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistantsEntity)) {
            return false;
        }
        AssistantsEntity other = (AssistantsEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$instructions = this.getInstructions();
        String other$instructions = other.getInstructions();
        if (this$instructions == null ? other$instructions != null : !this$instructions.equals(other$instructions)) {
            return false;
        }
        Set<Map<String, String>> this$tools = this.getTools();
        Set<Map<String, String>> other$tools = other.getTools();
        if (this$tools == null ? other$tools != null : !((Object)this$tools).equals(other$tools)) {
            return false;
        }
        Set<String> this$fileIds = this.getFileIds();
        Set<String> other$fileIds = other.getFileIds();
        if (this$fileIds == null ? other$fileIds != null : !((Object)this$fileIds).equals(other$fileIds)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssistantsEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $instructions = this.getInstructions();
        result = result * 59 + ($instructions == null ? 43 : $instructions.hashCode());
        Set<Map<String, String>> $tools = this.getTools();
        result = result * 59 + ($tools == null ? 43 : ((Object)$tools).hashCode());
        Set<String> $fileIds = this.getFileIds();
        result = result * 59 + ($fileIds == null ? 43 : ((Object)$fileIds).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "AssistantsEntity(id=" + this.getId() + ", model=" + this.getModel() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", instructions=" + this.getInstructions() + ", tools=" + this.getTools() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ")";
    }

    public AssistantsEntity() {
    }

    public AssistantsEntity(String id, String model, String name, String description, String instructions, Set<Map<String, String>> tools, Set<String> fileIds, Map<String, String> metadata) {
        this.id = id;
        this.model = model;
        this.name = name;
        this.description = description;
        this.instructions = instructions;
        this.tools = tools;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public static class AssistantsEntityBuilder {
        private String id;
        private String model;
        private String name;
        private String description;
        private String instructions;
        private Set<Map<String, String>> tools;
        private Set<String> fileIds;
        private Map<String, String> metadata;

        public AssistantsEntityBuilder model(CompletionModel model) {
            if (model == null) {
                throw new ParamException("Model cannot be null");
            }
            this.model = model.getName();
            return this;
        }

        public AssistantsEntityBuilder name(String name) {
            if (name.length() > 256) {
                throw new ParamException("Name cannot be longer than 256 characters");
            }
            this.name = name;
            return this;
        }

        public AssistantsEntityBuilder description(String description) {
            if (description.length() > 512) {
                throw new ParamException("Description cannot be longer than 512 characters");
            }
            this.description = description;
            return this;
        }

        public AssistantsEntityBuilder instructions(String instructions) {
            if (instructions.length() > 32768) {
                throw new ParamException("Instructions cannot be longer than 32768 characters");
            }
            this.instructions = instructions;
            return this;
        }

        public AssistantsEntityBuilder tools(Set<Map<String, String>> tools) {
            if (tools.size() > 128) {
                throw new ParamException("Tools cannot be longer than 128 characters");
            }
            this.tools = tools;
            return this;
        }

        public AssistantsEntityBuilder fileIds(Set<String> fileIds) {
            if (fileIds.size() > 20) {
                throw new ParamException("FileIds cannot be longer than 20 characters");
            }
            this.fileIds = fileIds;
            return this;
        }

        public AssistantsEntity build() {
            return new AssistantsEntity(this);
        }

        AssistantsEntityBuilder() {
        }

        @JsonProperty(value="id")
        public AssistantsEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadata")
        public AssistantsEntityBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public String toString() {
            return "AssistantsEntity.AssistantsEntityBuilder(id=" + this.id + ", model=" + this.model + ", name=" + this.name + ", description=" + this.description + ", instructions=" + this.instructions + ", tools=" + this.tools + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }
}

