/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.ModerationModel;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ModerationEntity {
    @JsonProperty(value="input")
    private List<String> inputs;
    @JsonProperty(value="model")
    private String model;

    private ModerationEntity(ModerationEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.inputs)) {
            builder.inputs(null);
        }
        this.inputs = builder.inputs;
        if (StringUtils.isEmpty((CharSequence)builder.model)) {
            builder.model(ModerationModel.TEXT_MODERATION_LATEST);
        }
        this.model = builder.model;
    }

    public static ModerationEntityBuilder builder() {
        return new ModerationEntityBuilder();
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public String getModel() {
        return this.model;
    }

    @JsonProperty(value="input")
    public void setInputs(List<String> inputs) {
        this.inputs = inputs;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModerationEntity)) {
            return false;
        }
        ModerationEntity other = (ModerationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$inputs = this.getInputs();
        List<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        return !(this$model == null ? other$model != null : !this$model.equals(other$model));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModerationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        return result;
    }

    public String toString() {
        return "ModerationEntity(inputs=" + this.getInputs() + ", model=" + this.getModel() + ")";
    }

    public ModerationEntity() {
    }

    public ModerationEntity(List<String> inputs, String model) {
        this.inputs = inputs;
        this.model = model;
    }

    public static class ModerationEntityBuilder {
        private List<String> inputs;
        private String model;

        public ModerationEntityBuilder inputs(List<String> inputs) {
            if (ObjectUtils.isEmpty(inputs) || inputs.size() == 0) {
                throw new ParamException("Invalid inputs must be non-empty");
            }
            this.inputs = inputs;
            return this;
        }

        public ModerationEntityBuilder model(ModerationModel model) {
            this.model = model.getName();
            return this;
        }

        public ModerationEntity build() {
            return new ModerationEntity(this);
        }

        ModerationEntityBuilder() {
        }

        public String toString() {
            return "ModerationEntity.ModerationEntityBuilder(inputs=" + this.inputs + ", model=" + this.model + ")";
        }
    }
}

