/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.MessageModel;
import org.devlive.sdk.openai.utils.EnumsUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MessageEntity {
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="file_ids")
    private Set<String> fileIds;
    @JsonProperty(value="metadata")
    private Map<Object, Object> metadata;

    private MessageEntity(MessageEntityBuilder builder) {
        if (StringUtils.isEmpty((CharSequence)builder.role)) {
            builder.role(MessageModel.USER.getName());
        }
        this.role = builder.role;
        if (StringUtils.isEmpty((CharSequence)builder.content)) {
            builder.content(null);
        }
        this.content = builder.content;
        if (StringUtils.isEmpty((CharSequence)builder.name)) {
            builder.name("openai-java-sdk");
        }
        this.name = builder.name;
        this.fileIds = builder.fileIds;
        this.metadata = builder.metadata;
    }

    public static MessageEntityBuilder builder() {
        return new MessageEntityBuilder();
    }

    public String getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFileIds() {
        return this.fileIds;
    }

    public Map<Object, Object> getMetadata() {
        return this.metadata;
    }

    @JsonProperty(value="role")
    public void setRole(String role) {
        this.role = role;
    }

    @JsonProperty(value="content")
    public void setContent(String content) {
        this.content = content;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="file_ids")
    public void setFileIds(Set<String> fileIds) {
        this.fileIds = fileIds;
    }

    @JsonProperty(value="metadata")
    public void setMetadata(Map<Object, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEntity)) {
            return false;
        }
        MessageEntity other = (MessageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Set<String> this$fileIds = this.getFileIds();
        Set<String> other$fileIds = other.getFileIds();
        if (this$fileIds == null ? other$fileIds != null : !((Object)this$fileIds).equals(other$fileIds)) {
            return false;
        }
        Map<Object, Object> this$metadata = this.getMetadata();
        Map<Object, Object> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Set<String> $fileIds = this.getFileIds();
        result = result * 59 + ($fileIds == null ? 43 : ((Object)$fileIds).hashCode());
        Map<Object, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "MessageEntity(role=" + this.getRole() + ", content=" + this.getContent() + ", name=" + this.getName() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ")";
    }

    public MessageEntity() {
    }

    public MessageEntity(String role, String content, String name, Set<String> fileIds, Map<Object, Object> metadata) {
        this.role = role;
        this.content = content;
        this.name = name;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    public static class MessageEntityBuilder {
        private String role;
        private String content;
        private String name;
        private Set<String> fileIds;
        private Map<Object, Object> metadata;

        public MessageEntityBuilder role(String role) {
            MessageModel messageModel = EnumsUtils.getCompleteMessageModel(role);
            if (ObjectUtils.isEmpty((Object)((Object)messageModel))) {
                throw new ParamException(String.format("Not support completion role %s", role));
            }
            this.role = role;
            return this;
        }

        public MessageEntityBuilder content(String content) {
            if (StringUtils.isEmpty((CharSequence)content)) {
                throw new ParamException("Content must not be empty");
            }
            this.content = content;
            return this;
        }

        public MessageEntity build() {
            return new MessageEntity(this);
        }

        MessageEntityBuilder() {
        }

        @JsonProperty(value="name")
        public MessageEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="file_ids")
        public MessageEntityBuilder fileIds(Set<String> fileIds) {
            this.fileIds = fileIds;
            return this;
        }

        @JsonProperty(value="metadata")
        public MessageEntityBuilder metadata(Map<Object, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public String toString() {
            return "MessageEntity.MessageEntityBuilder(role=" + this.role + ", content=" + this.content + ", name=" + this.name + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }
}

