/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.ImageFormatModel;
import org.devlive.sdk.openai.model.ImageSizeModel;
import org.devlive.sdk.openai.utils.MultipartBodyUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ImageEntity {
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="n")
    private Integer count;
    @JsonProperty(value="size")
    private String size;
    @JsonProperty(value="response_format")
    private String format = "url";
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="image")
    private File image;
    @JsonProperty(value="mask")
    private File mask;
    private Boolean isEdit;
    private Boolean isVariation;

    private ImageEntity(ImageEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.prompt)) {
            builder.prompt(null);
        }
        this.prompt = builder.prompt;
        if (ObjectUtils.isEmpty((Object)builder.count)) {
            builder.count(1);
        }
        this.count = builder.count;
        if (ObjectUtils.isEmpty((Object)builder.size)) {
            builder.size(ImageSizeModel.X_1024);
        }
        this.size = builder.size;
        if (ObjectUtils.isEmpty((Object)builder.format)) {
            builder.format(ImageFormatModel.url);
        }
        this.format = builder.format;
        if (ObjectUtils.isEmpty((Object)builder.image)) {
            builder.image(null);
        }
        this.image = builder.image;
        if (ObjectUtils.isEmpty((Object)builder.mask)) {
            builder.mask(null);
        }
        this.mask = builder.mask;
        if (ObjectUtils.isEmpty((Object)builder.isEdit)) {
            builder.isEdit(Boolean.FALSE);
        }
        this.isEdit = builder.isEdit;
        if (ObjectUtils.isEmpty((Object)builder.isVariation)) {
            builder.isVariation(Boolean.FALSE);
        }
        this.isVariation = builder.isVariation;
        this.user = builder.user;
    }

    public Map<String, RequestBody> convertMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        if (this.isEdit.booleanValue()) {
            map.put("prompt", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getPrompt()));
        }
        map.put("n", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getCount().toString()));
        map.put("size", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getSize()));
        map.put("response_format", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getFormat()));
        if (StringUtils.isNotEmpty((CharSequence)this.getUser())) {
            map.put("user", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getUser()));
        }
        return map;
    }

    public static ImageEntityBuilder builder() {
        return new ImageEntityBuilder();
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Integer getCount() {
        return this.count;
    }

    public String getSize() {
        return this.size;
    }

    public String getFormat() {
        return this.format;
    }

    public String getUser() {
        return this.user;
    }

    public String getUrl() {
        return this.url;
    }

    public File getImage() {
        return this.image;
    }

    public File getMask() {
        return this.mask;
    }

    public Boolean getIsEdit() {
        return this.isEdit;
    }

    public Boolean getIsVariation() {
        return this.isVariation;
    }

    @JsonProperty(value="prompt")
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="n")
    public void setCount(Integer count) {
        this.count = count;
    }

    @JsonProperty(value="size")
    public void setSize(String size) {
        this.size = size;
    }

    @JsonProperty(value="response_format")
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonProperty(value="image")
    public void setImage(File image) {
        this.image = image;
    }

    @JsonProperty(value="mask")
    public void setMask(File mask) {
        this.mask = mask;
    }

    public void setIsEdit(Boolean isEdit) {
        this.isEdit = isEdit;
    }

    public void setIsVariation(Boolean isVariation) {
        this.isVariation = isVariation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageEntity)) {
            return false;
        }
        ImageEntity other = (ImageEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Boolean this$isEdit = this.getIsEdit();
        Boolean other$isEdit = other.getIsEdit();
        if (this$isEdit == null ? other$isEdit != null : !((Object)this$isEdit).equals(other$isEdit)) {
            return false;
        }
        Boolean this$isVariation = this.getIsVariation();
        Boolean other$isVariation = other.getIsVariation();
        if (this$isVariation == null ? other$isVariation != null : !((Object)this$isVariation).equals(other$isVariation)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        File this$image = this.getImage();
        File other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        File this$mask = this.getMask();
        File other$mask = other.getMask();
        return !(this$mask == null ? other$mask != null : !((Object)this$mask).equals(other$mask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Boolean $isEdit = this.getIsEdit();
        result = result * 59 + ($isEdit == null ? 43 : ((Object)$isEdit).hashCode());
        Boolean $isVariation = this.getIsVariation();
        result = result * 59 + ($isVariation == null ? 43 : ((Object)$isVariation).hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        File $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        File $mask = this.getMask();
        result = result * 59 + ($mask == null ? 43 : ((Object)$mask).hashCode());
        return result;
    }

    public String toString() {
        return "ImageEntity(prompt=" + this.getPrompt() + ", count=" + this.getCount() + ", size=" + this.getSize() + ", format=" + this.getFormat() + ", user=" + this.getUser() + ", url=" + this.getUrl() + ", image=" + this.getImage() + ", mask=" + this.getMask() + ", isEdit=" + this.getIsEdit() + ", isVariation=" + this.getIsVariation() + ")";
    }

    public ImageEntity() {
    }

    public ImageEntity(String prompt, Integer count, String size, String format, String user, String url, File image, File mask, Boolean isEdit, Boolean isVariation) {
        this.prompt = prompt;
        this.count = count;
        this.size = size;
        this.format = format;
        this.user = user;
        this.url = url;
        this.image = image;
        this.mask = mask;
        this.isEdit = isEdit;
        this.isVariation = isVariation;
    }

    public static class ImageEntityBuilder {
        private String prompt;
        private Integer count;
        private String size;
        private String format;
        private String user;
        private String url;
        private File image;
        private File mask;
        private Boolean isEdit;
        private Boolean isVariation;

        public ImageEntityBuilder prompt(String prompt) {
            if ((ObjectUtils.isEmpty((Object)this.isVariation) || !this.isVariation.booleanValue()) && StringUtils.isEmpty((CharSequence)prompt)) {
                throw new ParamException("Invalid prompt must not be empty");
            }
            this.prompt = prompt;
            return this;
        }

        public ImageEntityBuilder count(Integer count) {
            if (count < 1 || count > 10) {
                throw new ParamException(String.format("Invalid count: %s , between 1 and 10", count));
            }
            this.count = count;
            return this;
        }

        public ImageEntityBuilder size(ImageSizeModel size) {
            Enum instance = EnumUtils.getEnum(ImageSizeModel.class, (String)size.name());
            if (ObjectUtils.isEmpty((Object)instance)) {
                throw new ParamException(String.format("Invalid size: %s , Must be one of %s", new Object[]{size, Arrays.toString((Object[])ImageSizeModel.values())}));
            }
            this.size = size.getName();
            return this;
        }

        public ImageEntityBuilder format(ImageFormatModel format) {
            Enum instance = EnumUtils.getEnum(ImageFormatModel.class, (String)format.name());
            if (ObjectUtils.isEmpty((Object)instance)) {
                throw new ParamException(String.format("Invalid format: %s , Must be one of %s", new Object[]{format, Arrays.toString((Object[])ImageFormatModel.values())}));
            }
            this.format = format.name();
            return this;
        }

        public ImageEntityBuilder image(File image) {
            if (ObjectUtils.isNotEmpty((Object)image) && image.length() > 417792L) {
                throw new ParamException("Must be less than 4MB");
            }
            this.image = image;
            return this;
        }

        public ImageEntityBuilder mask(File mask) {
            if (ObjectUtils.isNotEmpty((Object)mask) && mask.length() > 417792L) {
                throw new ParamException("Must be less than 4MB");
            }
            this.mask = mask;
            return this;
        }

        public ImageEntityBuilder isEdit(Boolean isEdit) {
            if (isEdit.booleanValue() && ObjectUtils.isEmpty((Object)this.image)) {
                throw new ParamException("Image must not be empty.");
            }
            this.isEdit = isEdit;
            return this;
        }

        public ImageEntityBuilder isVariation(Boolean isVariation) {
            if (isVariation.booleanValue() && ObjectUtils.isNotEmpty((Object)this.prompt)) {
                throw new ParamException("Please remove prompt");
            }
            if (isVariation.booleanValue() && ObjectUtils.isEmpty((Object)this.image)) {
                throw new ParamException("Image must not be empty.");
            }
            this.isVariation = isVariation;
            return this;
        }

        public ImageEntity build() {
            return new ImageEntity(this);
        }

        ImageEntityBuilder() {
        }

        @JsonProperty(value="user")
        public ImageEntityBuilder user(String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="url")
        public ImageEntityBuilder url(String url) {
            this.url = url;
            return this;
        }

        public String toString() {
            return "ImageEntity.ImageEntityBuilder(prompt=" + this.prompt + ", count=" + this.count + ", size=" + this.size + ", format=" + this.format + ", user=" + this.user + ", url=" + this.url + ", image=" + this.image + ", mask=" + this.mask + ", isEdit=" + this.isEdit + ", isVariation=" + this.isVariation + ")";
        }
    }
}

