/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.CompletionModel;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FineTuningEntity {
    @JsonProperty(value="after")
    private String after;
    @JsonProperty(value="limit")
    private Integer limit;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="training_file")
    private String file;
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String createTime;
    @JsonProperty(value="finished_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String finishTime;
    @JsonProperty(value="level")
    private String level;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="data")
    private String data;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="fine_tuned_model")
    private String tunedModel;
    @JsonProperty(value="organization_id")
    private String organizationId;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="validation_file")
    private String validationFile;
    @JsonProperty(value="trained_tokens")
    private Long trainedTokens;

    private FineTuningEntity(FineTuningEntityBuilder builder) {
        if (builder.limit == null) {
            builder.limit(null);
        }
        this.limit = builder.limit;
        this.after = builder.after;
        if (builder.model == null) {
            builder.model(CompletionModel.GPT_35_TURBO);
        }
        this.model = builder.model;
        if (builder.file == null) {
            builder.file(null);
        }
        this.file = builder.file;
    }

    public static FineTuningEntityBuilder builder() {
        return new FineTuningEntityBuilder();
    }

    public String getAfter() {
        return this.after;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getModel() {
        return this.model;
    }

    public String getFile() {
        return this.file;
    }

    public String getObject() {
        return this.object;
    }

    public String getId() {
        return this.id;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public String getFinishTime() {
        return this.finishTime;
    }

    public String getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }

    public String getType() {
        return this.type;
    }

    public String getTunedModel() {
        return this.tunedModel;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getValidationFile() {
        return this.validationFile;
    }

    public Long getTrainedTokens() {
        return this.trainedTokens;
    }

    @JsonProperty(value="after")
    public void setAfter(String after) {
        this.after = after;
    }

    @JsonProperty(value="limit")
    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="training_file")
    public void setFile(String file) {
        this.file = file;
    }

    @JsonProperty(value="object")
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JsonProperty(value="finished_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setFinishTime(String finishTime) {
        this.finishTime = finishTime;
    }

    @JsonProperty(value="level")
    public void setLevel(String level) {
        this.level = level;
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonProperty(value="data")
    public void setData(String data) {
        this.data = data;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="fine_tuned_model")
    public void setTunedModel(String tunedModel) {
        this.tunedModel = tunedModel;
    }

    @JsonProperty(value="organization_id")
    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="validation_file")
    public void setValidationFile(String validationFile) {
        this.validationFile = validationFile;
    }

    @JsonProperty(value="trained_tokens")
    public void setTrainedTokens(Long trainedTokens) {
        this.trainedTokens = trainedTokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FineTuningEntity)) {
            return false;
        }
        FineTuningEntity other = (FineTuningEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$trainedTokens = this.getTrainedTokens();
        Long other$trainedTokens = other.getTrainedTokens();
        if (this$trainedTokens == null ? other$trainedTokens != null : !((Object)this$trainedTokens).equals(other$trainedTokens)) {
            return false;
        }
        String this$after = this.getAfter();
        String other$after = other.getAfter();
        if (this$after == null ? other$after != null : !this$after.equals(other$after)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$createTime = this.getCreateTime();
        String other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) {
            return false;
        }
        String this$finishTime = this.getFinishTime();
        String other$finishTime = other.getFinishTime();
        if (this$finishTime == null ? other$finishTime != null : !this$finishTime.equals(other$finishTime)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$tunedModel = this.getTunedModel();
        String other$tunedModel = other.getTunedModel();
        if (this$tunedModel == null ? other$tunedModel != null : !this$tunedModel.equals(other$tunedModel)) {
            return false;
        }
        String this$organizationId = this.getOrganizationId();
        String other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$validationFile = this.getValidationFile();
        String other$validationFile = other.getValidationFile();
        return !(this$validationFile == null ? other$validationFile != null : !this$validationFile.equals(other$validationFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FineTuningEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $trainedTokens = this.getTrainedTokens();
        result = result * 59 + ($trainedTokens == null ? 43 : ((Object)$trainedTokens).hashCode());
        String $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : $after.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : $createTime.hashCode());
        String $finishTime = this.getFinishTime();
        result = result * 59 + ($finishTime == null ? 43 : $finishTime.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $tunedModel = this.getTunedModel();
        result = result * 59 + ($tunedModel == null ? 43 : $tunedModel.hashCode());
        String $organizationId = this.getOrganizationId();
        result = result * 59 + ($organizationId == null ? 43 : $organizationId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $validationFile = this.getValidationFile();
        result = result * 59 + ($validationFile == null ? 43 : $validationFile.hashCode());
        return result;
    }

    public String toString() {
        return "FineTuningEntity(after=" + this.getAfter() + ", limit=" + this.getLimit() + ", model=" + this.getModel() + ", file=" + this.getFile() + ", object=" + this.getObject() + ", id=" + this.getId() + ", createTime=" + this.getCreateTime() + ", finishTime=" + this.getFinishTime() + ", level=" + this.getLevel() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", type=" + this.getType() + ", tunedModel=" + this.getTunedModel() + ", organizationId=" + this.getOrganizationId() + ", status=" + this.getStatus() + ", validationFile=" + this.getValidationFile() + ", trainedTokens=" + this.getTrainedTokens() + ")";
    }

    public FineTuningEntity() {
    }

    public FineTuningEntity(String after, Integer limit, String model, String file, String object, String id, String createTime, String finishTime, String level, String message, String data, String type, String tunedModel, String organizationId, String status, String validationFile, Long trainedTokens) {
        this.after = after;
        this.limit = limit;
        this.model = model;
        this.file = file;
        this.object = object;
        this.id = id;
        this.createTime = createTime;
        this.finishTime = finishTime;
        this.level = level;
        this.message = message;
        this.data = data;
        this.type = type;
        this.tunedModel = tunedModel;
        this.organizationId = organizationId;
        this.status = status;
        this.validationFile = validationFile;
        this.trainedTokens = trainedTokens;
    }

    public static class FineTuningEntityBuilder {
        private String after;
        private Integer limit;
        private String model;
        private String file;
        private String object;
        private String id;
        private String createTime;
        private String finishTime;
        private String level;
        private String message;
        private String data;
        private String type;
        private String tunedModel;
        private String organizationId;
        private String status;
        private String validationFile;
        private Long trainedTokens;

        public FineTuningEntityBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public FineTuningEntityBuilder after(String after) {
            this.after = after;
            return this;
        }

        public FineTuningEntityBuilder model(CompletionModel model) {
            if (model == null) {
                model = CompletionModel.GPT_35_TURBO;
            }
            switch (model) {
                case GPT_35_TURBO: 
                case GPT_35_TURBO_0613: 
                case BABBAGE_002: 
                case DAVINCI_002: 
                case GPT_4_0613: {
                    this.model = model.getName();
                    break;
                }
                default: {
                    throw new ParamException(String.format("Not support completion model %s", new Object[]{model}));
                }
            }
            return this;
        }

        public FineTuningEntityBuilder file(String file) {
            if (file == null) {
                throw new ParamException("Invalid file name must not be empty");
            }
            this.file = file;
            return this;
        }

        public FineTuningEntity build() {
            return new FineTuningEntity(this);
        }

        FineTuningEntityBuilder() {
        }

        @JsonProperty(value="object")
        public FineTuningEntityBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="id")
        public FineTuningEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="created_at")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public FineTuningEntityBuilder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        @JsonProperty(value="finished_at")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public FineTuningEntityBuilder finishTime(String finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        @JsonProperty(value="level")
        public FineTuningEntityBuilder level(String level) {
            this.level = level;
            return this;
        }

        @JsonProperty(value="message")
        public FineTuningEntityBuilder message(String message) {
            this.message = message;
            return this;
        }

        @JsonProperty(value="data")
        public FineTuningEntityBuilder data(String data) {
            this.data = data;
            return this;
        }

        @JsonProperty(value="type")
        public FineTuningEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="fine_tuned_model")
        public FineTuningEntityBuilder tunedModel(String tunedModel) {
            this.tunedModel = tunedModel;
            return this;
        }

        @JsonProperty(value="organization_id")
        public FineTuningEntityBuilder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @JsonProperty(value="status")
        public FineTuningEntityBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="validation_file")
        public FineTuningEntityBuilder validationFile(String validationFile) {
            this.validationFile = validationFile;
            return this;
        }

        @JsonProperty(value="trained_tokens")
        public FineTuningEntityBuilder trainedTokens(Long trainedTokens) {
            this.trainedTokens = trainedTokens;
            return this;
        }

        public String toString() {
            return "FineTuningEntity.FineTuningEntityBuilder(after=" + this.after + ", limit=" + this.limit + ", model=" + this.model + ", file=" + this.file + ", object=" + this.object + ", id=" + this.id + ", createTime=" + this.createTime + ", finishTime=" + this.finishTime + ", level=" + this.level + ", message=" + this.message + ", data=" + this.data + ", type=" + this.type + ", tunedModel=" + this.tunedModel + ", organizationId=" + this.organizationId + ", status=" + this.status + ", validationFile=" + this.validationFile + ", trainedTokens=" + this.trainedTokens + ")";
        }
    }
}

