/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.ObjectUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.PurposeModel;
import org.devlive.sdk.openai.utils.MultipartBodyUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileEntity {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="bytes")
    private Integer bytes;
    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private String createdTime;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="purpose")
    private String purpose;
    @JsonProperty(value="status")
    private String status;
    @JsonProperty(value="status_details")
    private String statusDetails;
    @JsonProperty(value="file")
    private File file;

    private FileEntity(FileEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.file)) {
            builder.file(null);
        }
        this.file = builder.file;
        if (ObjectUtils.isEmpty((Object)builder.purpose)) {
            builder.purpose(PurposeModel.FINE_TUNE);
        }
        this.purpose = builder.purpose;
    }

    public Map<String, RequestBody> convertMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put("purpose", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getPurpose()));
        return map;
    }

    public static FileEntityBuilder builder() {
        return new FileEntityBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public Integer getBytes() {
        return this.bytes;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatusDetails() {
        return this.statusDetails;
    }

    public File getFile() {
        return this.file;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="object")
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="bytes")
    public void setBytes(Integer bytes) {
        this.bytes = bytes;
    }

    @JsonProperty(value="created_at")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    @JsonProperty(value="filename")
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @JsonProperty(value="purpose")
    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    @JsonProperty(value="status")
    public void setStatus(String status) {
        this.status = status;
    }

    @JsonProperty(value="status_details")
    public void setStatusDetails(String statusDetails) {
        this.statusDetails = statusDetails;
    }

    @JsonProperty(value="file")
    public void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileEntity)) {
            return false;
        }
        FileEntity other = (FileEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$bytes = this.getBytes();
        Integer other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$createdTime = this.getCreatedTime();
        String other$createdTime = other.getCreatedTime();
        if (this$createdTime == null ? other$createdTime != null : !this$createdTime.equals(other$createdTime)) {
            return false;
        }
        String this$filename = this.getFilename();
        String other$filename = other.getFilename();
        if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
            return false;
        }
        String this$purpose = this.getPurpose();
        String other$purpose = other.getPurpose();
        if (this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$statusDetails = this.getStatusDetails();
        String other$statusDetails = other.getStatusDetails();
        if (this$statusDetails == null ? other$statusDetails != null : !this$statusDetails.equals(other$statusDetails)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $createdTime = this.getCreatedTime();
        result = result * 59 + ($createdTime == null ? 43 : $createdTime.hashCode());
        String $filename = this.getFilename();
        result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
        String $purpose = this.getPurpose();
        result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $statusDetails = this.getStatusDetails();
        result = result * 59 + ($statusDetails == null ? 43 : $statusDetails.hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }

    public String toString() {
        return "FileEntity(id=" + this.getId() + ", object=" + this.getObject() + ", bytes=" + this.getBytes() + ", createdTime=" + this.getCreatedTime() + ", filename=" + this.getFilename() + ", purpose=" + this.getPurpose() + ", status=" + this.getStatus() + ", statusDetails=" + this.getStatusDetails() + ", file=" + this.getFile() + ")";
    }

    public FileEntity() {
    }

    public FileEntity(String id, String object, Integer bytes, String createdTime, String filename, String purpose, String status, String statusDetails, File file) {
        this.id = id;
        this.object = object;
        this.bytes = bytes;
        this.createdTime = createdTime;
        this.filename = filename;
        this.purpose = purpose;
        this.status = status;
        this.statusDetails = statusDetails;
        this.file = file;
    }

    public static class FileEntityBuilder {
        private String id;
        private String object;
        private Integer bytes;
        private String createdTime;
        private String filename;
        private String purpose;
        private String status;
        private String statusDetails;
        private File file;

        public FileEntityBuilder file(File file) {
            if (ObjectUtils.isEmpty((Object)file)) {
                throw new ParamException("Invalid file must not be empty");
            }
            this.file = file;
            return this;
        }

        public FileEntityBuilder purpose(PurposeModel purpose) {
            this.purpose = purpose.getName();
            return this;
        }

        public FileEntity build() {
            return new FileEntity(this);
        }

        FileEntityBuilder() {
        }

        @JsonProperty(value="id")
        public FileEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="object")
        public FileEntityBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="bytes")
        public FileEntityBuilder bytes(Integer bytes) {
            this.bytes = bytes;
            return this;
        }

        @JsonProperty(value="created_at")
        @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
        public FileEntityBuilder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @JsonProperty(value="filename")
        public FileEntityBuilder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @JsonProperty(value="status")
        public FileEntityBuilder status(String status) {
            this.status = status;
            return this;
        }

        @JsonProperty(value="status_details")
        public FileEntityBuilder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public String toString() {
            return "FileEntity.FileEntityBuilder(id=" + this.id + ", object=" + this.object + ", bytes=" + this.bytes + ", createdTime=" + this.createdTime + ", filename=" + this.filename + ", purpose=" + this.purpose + ", status=" + this.status + ", statusDetails=" + this.statusDetails + ", file=" + this.file + ")";
        }
    }
}

