/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EmbeddingEntity {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="input")
    private String input;
    @JsonProperty(value="user")
    private String user;
    @JsonProperty(value="object")
    private String object;
    @JsonProperty(value="embedding")
    private List<Object> embeddings;
    @JsonProperty(value="index")
    private long index;

    private EmbeddingEntity(EmbeddingEntityBuilder builder) {
        if (StringUtils.isEmpty((CharSequence)builder.model)) {
            builder.model(null);
        }
        this.model = builder.model;
        if (StringUtils.isEmpty((CharSequence)builder.input)) {
            builder.input(null);
        }
        this.input = builder.input;
        this.user = builder.user;
    }

    public static EmbeddingEntityBuilder builder() {
        return new EmbeddingEntityBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getInput() {
        return this.input;
    }

    public String getUser() {
        return this.user;
    }

    public String getObject() {
        return this.object;
    }

    public List<Object> getEmbeddings() {
        return this.embeddings;
    }

    public long getIndex() {
        return this.index;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="input")
    public void setInput(String input) {
        this.input = input;
    }

    @JsonProperty(value="user")
    public void setUser(String user) {
        this.user = user;
    }

    @JsonProperty(value="object")
    public void setObject(String object) {
        this.object = object;
    }

    @JsonProperty(value="embedding")
    public void setEmbeddings(List<Object> embeddings) {
        this.embeddings = embeddings;
    }

    @JsonProperty(value="index")
    public void setIndex(long index) {
        this.index = index;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingEntity)) {
            return false;
        }
        EmbeddingEntity other = (EmbeddingEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Object> this$embeddings = this.getEmbeddings();
        List<Object> other$embeddings = other.getEmbeddings();
        return !(this$embeddings == null ? other$embeddings != null : !((Object)this$embeddings).equals(other$embeddings));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmbeddingEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $index = this.getIndex();
        result = result * 59 + (int)($index >>> 32 ^ $index);
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Object> $embeddings = this.getEmbeddings();
        result = result * 59 + ($embeddings == null ? 43 : ((Object)$embeddings).hashCode());
        return result;
    }

    public String toString() {
        return "EmbeddingEntity(model=" + this.getModel() + ", input=" + this.getInput() + ", user=" + this.getUser() + ", object=" + this.getObject() + ", embeddings=" + this.getEmbeddings() + ", index=" + this.getIndex() + ")";
    }

    public EmbeddingEntity() {
    }

    public EmbeddingEntity(String model, String input, String user, String object, List<Object> embeddings, long index) {
        this.model = model;
        this.input = input;
        this.user = user;
        this.object = object;
        this.embeddings = embeddings;
        this.index = index;
    }

    public static class EmbeddingEntityBuilder {
        private String model;
        private String input;
        private String user;
        private String object;
        private List<Object> embeddings;
        private long index;

        public EmbeddingEntityBuilder model(String model) {
            if (!(model.equals("text-embedding-ada-002") || model.startsWith("text-similarity-") && model.endsWith("-001") || model.startsWith("text-search-") && model.endsWith("-001") || model.startsWith("code-search-") && model.endsWith("-001"))) {
                throw new ParamException(String.format("Invalid model %s must be specified, Support text-embedding-ada-002, text-similarity-*-001, text-search-*-*-001, code-search-*-*-001", model));
            }
            this.model = model;
            return this;
        }

        public EmbeddingEntityBuilder input(String input) {
            if (StringUtils.isEmpty((CharSequence)input)) {
                throw new ParamException("Invalid input must be not empty");
            }
            this.input = input;
            return this;
        }

        public EmbeddingEntity build() {
            return new EmbeddingEntity(this);
        }

        EmbeddingEntityBuilder() {
        }

        @JsonProperty(value="user")
        public EmbeddingEntityBuilder user(String user) {
            this.user = user;
            return this;
        }

        @JsonProperty(value="object")
        public EmbeddingEntityBuilder object(String object) {
            this.object = object;
            return this;
        }

        @JsonProperty(value="embedding")
        public EmbeddingEntityBuilder embeddings(List<Object> embeddings) {
            this.embeddings = embeddings;
            return this;
        }

        @JsonProperty(value="index")
        public EmbeddingEntityBuilder index(long index) {
            this.index = index;
            return this;
        }

        public String toString() {
            return "EmbeddingEntity.EmbeddingEntityBuilder(model=" + this.model + ", input=" + this.input + ", user=" + this.user + ", object=" + this.object + ", embeddings=" + this.embeddings + ", index=" + this.index + ")";
        }
    }
}

