/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.EditModel;

@JsonIgnoreProperties(ignoreUnknown=true)
@Deprecated
public class EditEntity {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="input")
    private String input;
    @JsonProperty(value="instruction")
    private String instruction;
    @JsonProperty(value="n")
    private Integer count;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="top_p")
    private Double topP;

    private EditEntity(EditEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.model)) {
            throw new ParamException(String.format("Invalid model, Must be one of %s", Arrays.toString((Object[])EditModel.values())));
        }
        this.model = builder.model;
        if (StringUtils.isEmpty((CharSequence)builder.input)) {
            builder.input(null);
        }
        this.input = builder.input;
        if (StringUtils.isEmpty((CharSequence)builder.instruction)) {
            builder.instruction(null);
        }
        this.instruction = builder.instruction;
        if (ObjectUtils.isEmpty((Object)builder.count)) {
            builder.count(1);
        }
        this.count = builder.count;
        if (ObjectUtils.isEmpty((Object)builder.temperature)) {
            builder.temperature(1.0);
        }
        this.temperature = builder.temperature;
        if (ObjectUtils.isEmpty((Object)builder.topP)) {
            builder.topP(1.0);
        }
        this.topP = builder.topP;
    }

    public static EditEntityBuilder builder() {
        return new EditEntityBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getInput() {
        return this.input;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public Integer getCount() {
        return this.count;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Double getTopP() {
        return this.topP;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="input")
    public void setInput(String input) {
        this.input = input;
    }

    @JsonProperty(value="instruction")
    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    @JsonProperty(value="n")
    public void setCount(Integer count) {
        this.count = count;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EditEntity)) {
            return false;
        }
        EditEntity other = (EditEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$instruction = this.getInstruction();
        String other$instruction = other.getInstruction();
        return !(this$instruction == null ? other$instruction != null : !this$instruction.equals(other$instruction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EditEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $instruction = this.getInstruction();
        result = result * 59 + ($instruction == null ? 43 : $instruction.hashCode());
        return result;
    }

    public String toString() {
        return "EditEntity(model=" + this.getModel() + ", input=" + this.getInput() + ", instruction=" + this.getInstruction() + ", count=" + this.getCount() + ", temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ")";
    }

    public EditEntity() {
    }

    public EditEntity(String model, String input, String instruction, Integer count, Double temperature, Double topP) {
        this.model = model;
        this.input = input;
        this.instruction = instruction;
        this.count = count;
        this.temperature = temperature;
        this.topP = topP;
    }

    public static class EditEntityBuilder {
        private String model;
        private String input;
        private String instruction;
        private Integer count;
        private Double temperature;
        private Double topP;

        public EditEntityBuilder model(EditModel model) {
            this.model = model.getName();
            return this;
        }

        public EditEntityBuilder input(String input) {
            if (StringUtils.isEmpty((CharSequence)input)) {
                throw new ParamException("Invalid input must be not empty");
            }
            this.input = input;
            return this;
        }

        public EditEntityBuilder instruction(String instruction) {
            if (StringUtils.isEmpty((CharSequence)instruction)) {
                throw new ParamException("Invalid instruction must be not empty");
            }
            this.instruction = instruction;
            return this;
        }

        public EditEntityBuilder temperature(Double temperature) {
            if (temperature < 0.0 || temperature > 2.0) {
                throw new ParamException(String.format("Invalid temperature: %s , between 0 and 2", temperature));
            }
            this.temperature = temperature;
            return this;
        }

        public EditEntity build() {
            return new EditEntity(this);
        }

        EditEntityBuilder() {
        }

        @JsonProperty(value="n")
        public EditEntityBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        @JsonProperty(value="top_p")
        public EditEntityBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public String toString() {
            return "EditEntity.EditEntityBuilder(model=" + this.model + ", input=" + this.input + ", instruction=" + this.instruction + ", count=" + this.count + ", temperature=" + this.temperature + ", topP=" + this.topP + ")";
        }
    }
}

