/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.CompletionModel;
import org.devlive.sdk.openai.utils.EnumsUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompletionEntity {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="prompt", required=true)
    private String prompt;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="max_tokens")
    @JsonAlias(value={"max_tokens_to_sample"})
    private Integer maxTokens;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="best_of")
    private Integer bestOf;
    @JsonProperty(value="frequency_penalty")
    private Double frequencyPenalty;
    @JsonProperty(value="presence_penalty")
    private Double presencePenalty;
    @JsonProperty(value="stop")
    private List<String> stop;
    @JsonProperty(value="stream")
    private boolean stream = false;

    private CompletionEntity(CompletionEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.model)) {
            builder.model(CompletionModel.TEXT_DAVINCI_003);
        }
        this.model = builder.model;
        if (ObjectUtils.isEmpty((Object)builder.prompt)) {
            builder.prompt(null);
        }
        this.prompt = builder.prompt;
        if (ObjectUtils.isEmpty((Object)builder.temperature)) {
            builder.temperature(1.0);
        }
        this.temperature = builder.temperature;
        if (ObjectUtils.isEmpty((Object)builder.maxTokens)) {
            builder.maxTokens(16);
        }
        this.maxTokens = builder.maxTokens;
        if (ObjectUtils.isEmpty((Object)builder.topP)) {
            builder.topP(1.0);
        }
        this.topP = builder.topP;
        if (ObjectUtils.isEmpty((Object)builder.bestOf)) {
            builder.bestOf(1);
        }
        this.bestOf = builder.bestOf;
        if (ObjectUtils.isEmpty((Object)builder.frequencyPenalty)) {
            builder.frequencyPenalty(0.0);
        }
        this.frequencyPenalty = builder.frequencyPenalty;
        if (ObjectUtils.isEmpty((Object)builder.presencePenalty)) {
            builder.presencePenalty(0.0);
        }
        this.presencePenalty = builder.presencePenalty;
        this.stop = builder.stop;
    }

    public static CompletionEntityBuilder builder() {
        return new CompletionEntityBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTopP() {
        return this.topP;
    }

    public Integer getBestOf() {
        return this.bestOf;
    }

    public Double getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public Double getPresencePenalty() {
        return this.presencePenalty;
    }

    public List<String> getStop() {
        return this.stop;
    }

    public boolean isStream() {
        return this.stream;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="prompt", required=true)
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="max_tokens")
    @JsonAlias(value={"max_tokens_to_sample"})
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="best_of")
    public void setBestOf(Integer bestOf) {
        this.bestOf = bestOf;
    }

    @JsonProperty(value="frequency_penalty")
    public void setFrequencyPenalty(Double frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    @JsonProperty(value="presence_penalty")
    public void setPresencePenalty(Double presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    @JsonProperty(value="stop")
    public void setStop(List<String> stop) {
        this.stop = stop;
    }

    @JsonProperty(value="stream")
    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CompletionEntity)) {
            return false;
        }
        CompletionEntity other = (CompletionEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Integer this$bestOf = this.getBestOf();
        Integer other$bestOf = other.getBestOf();
        if (this$bestOf == null ? other$bestOf != null : !((Object)this$bestOf).equals(other$bestOf)) {
            return false;
        }
        Double this$frequencyPenalty = this.getFrequencyPenalty();
        Double other$frequencyPenalty = other.getFrequencyPenalty();
        if (this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty)) {
            return false;
        }
        Double this$presencePenalty = this.getPresencePenalty();
        Double other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        List<String> this$stop = this.getStop();
        List<String> other$stop = other.getStop();
        return !(this$stop == null ? other$stop != null : !((Object)this$stop).equals(other$stop));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CompletionEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Integer $bestOf = this.getBestOf();
        result = result * 59 + ($bestOf == null ? 43 : ((Object)$bestOf).hashCode());
        Double $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        Double $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        List<String> $stop = this.getStop();
        result = result * 59 + ($stop == null ? 43 : ((Object)$stop).hashCode());
        return result;
    }

    public String toString() {
        return "CompletionEntity(model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", topP=" + this.getTopP() + ", bestOf=" + this.getBestOf() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ", presencePenalty=" + this.getPresencePenalty() + ", stop=" + this.getStop() + ", stream=" + this.isStream() + ")";
    }

    public CompletionEntity(String model, String prompt, Double temperature, Integer maxTokens, Double topP, Integer bestOf, Double frequencyPenalty, Double presencePenalty, List<String> stop, boolean stream) {
        this.model = model;
        this.prompt = prompt;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.topP = topP;
        this.bestOf = bestOf;
        this.frequencyPenalty = frequencyPenalty;
        this.presencePenalty = presencePenalty;
        this.stop = stop;
        this.stream = stream;
    }

    public static class CompletionEntityBuilder {
        private String model;
        private String prompt;
        private Double temperature;
        private Integer maxTokens;
        private Double topP;
        private Integer bestOf;
        private Double frequencyPenalty;
        private Double presencePenalty;
        private List<String> stop;
        private boolean stream;

        public CompletionEntityBuilder model(CompletionModel model) {
            if (ObjectUtils.isEmpty((Object)((Object)model))) {
                model = CompletionModel.TEXT_DAVINCI_003;
            }
            this.model = model.getName();
            return this;
        }

        public CompletionEntityBuilder prompt(String prompt) {
            if (StringUtils.isEmpty((CharSequence)prompt)) {
                throw new ParamException("Invalid prompt must not be empty");
            }
            this.prompt = prompt;
            return this;
        }

        public CompletionEntityBuilder temperature(Double temperature) {
            if (temperature < 0.0 || temperature > 2.0) {
                throw new ParamException(String.format("Invalid temperature: %s , between 0 and 2", temperature));
            }
            this.temperature = temperature;
            return this;
        }

        public CompletionEntityBuilder maxTokens(Integer maxTokens) {
            CompletionModel completionModel = EnumsUtils.getCompleteModel(this.model);
            if (ObjectUtils.isNotEmpty((Object)this.model) && maxTokens > completionModel.getMaxTokens()) {
                throw new ParamException(String.format("Invalid maxTokens: %s, Cannot be larger than the model default configuration %s", maxTokens, completionModel.getMaxTokens()));
            }
            this.maxTokens = maxTokens;
            return this;
        }

        public CompletionEntityBuilder frequencyPenalty(Double frequencyPenalty) {
            if (frequencyPenalty < -2.0 || frequencyPenalty > 2.0) {
                throw new ParamException(String.format("Invalid frequencyPenalty: %s , between -2.0 and 2.0", frequencyPenalty));
            }
            this.frequencyPenalty = frequencyPenalty;
            return this;
        }

        public CompletionEntityBuilder presencePenalty(Double presencePenalty) {
            if (presencePenalty < -2.0 || presencePenalty > 2.0) {
                throw new ParamException(String.format("Invalid presencePenalty: %s , between -2.0 and 2.0", presencePenalty));
            }
            this.presencePenalty = presencePenalty;
            return this;
        }

        private CompletionEntityBuilder stream() {
            return this;
        }

        public CompletionEntity build() {
            return new CompletionEntity(this);
        }

        CompletionEntityBuilder() {
        }

        @JsonProperty(value="top_p")
        public CompletionEntityBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        @JsonProperty(value="best_of")
        public CompletionEntityBuilder bestOf(Integer bestOf) {
            this.bestOf = bestOf;
            return this;
        }

        @JsonProperty(value="stop")
        public CompletionEntityBuilder stop(List<String> stop) {
            this.stop = stop;
            return this;
        }

        public String toString() {
            return "CompletionEntity.CompletionEntityBuilder(model=" + this.model + ", prompt=" + this.prompt + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", topP=" + this.topP + ", bestOf=" + this.bestOf + ", frequencyPenalty=" + this.frequencyPenalty + ", presencePenalty=" + this.presencePenalty + ", stop=" + this.stop + ", stream=" + this.stream + ")";
        }
    }
}

