/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.devlive.sdk.openai.entity.MessageEntity;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.CompletionModel;
import org.devlive.sdk.openai.utils.EnumsUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ChatEntity {
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="messages")
    private List<MessageEntity> messages;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="max_tokens")
    private Integer maxTokens;
    @JsonProperty(value="top_p")
    private Double topP;
    @JsonProperty(value="stream")
    private boolean stream = false;

    private ChatEntity(ChatEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.model)) {
            builder.model(CompletionModel.GPT_35_TURBO);
        }
        this.model = builder.model;
        this.messages = builder.messages;
        if (ObjectUtils.isEmpty((Object)builder.temperature)) {
            builder.temperature(1.0);
        }
        this.temperature = builder.temperature;
        if (ObjectUtils.isEmpty((Object)builder.maxTokens)) {
            builder.maxTokens(256);
        }
        this.maxTokens = builder.maxTokens;
        if (ObjectUtils.isEmpty((Object)builder.topP)) {
            builder.topP(1.0);
        }
        this.topP = builder.topP;
    }

    public static ChatEntityBuilder builder() {
        return new ChatEntityBuilder();
    }

    public String getModel() {
        return this.model;
    }

    public List<MessageEntity> getMessages() {
        return this.messages;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public Double getTopP() {
        return this.topP;
    }

    public boolean isStream() {
        return this.stream;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="messages")
    public void setMessages(List<MessageEntity> messages) {
        this.messages = messages;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="max_tokens")
    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    @JsonProperty(value="top_p")
    public void setTopP(Double topP) {
        this.topP = topP;
    }

    @JsonProperty(value="stream")
    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatEntity)) {
            return false;
        }
        ChatEntity other = (ChatEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStream() != other.isStream()) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Integer this$maxTokens = this.getMaxTokens();
        Integer other$maxTokens = other.getMaxTokens();
        if (this$maxTokens == null ? other$maxTokens != null : !((Object)this$maxTokens).equals(other$maxTokens)) {
            return false;
        }
        Double this$topP = this.getTopP();
        Double other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        List<MessageEntity> this$messages = this.getMessages();
        List<MessageEntity> other$messages = other.getMessages();
        return !(this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStream() ? 79 : 97);
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Integer $maxTokens = this.getMaxTokens();
        result = result * 59 + ($maxTokens == null ? 43 : ((Object)$maxTokens).hashCode());
        Double $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        List<MessageEntity> $messages = this.getMessages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        return result;
    }

    public String toString() {
        return "ChatEntity(model=" + this.getModel() + ", messages=" + this.getMessages() + ", temperature=" + this.getTemperature() + ", maxTokens=" + this.getMaxTokens() + ", topP=" + this.getTopP() + ", stream=" + this.isStream() + ")";
    }

    public ChatEntity() {
    }

    public ChatEntity(String model, List<MessageEntity> messages, Double temperature, Integer maxTokens, Double topP, boolean stream) {
        this.model = model;
        this.messages = messages;
        this.temperature = temperature;
        this.maxTokens = maxTokens;
        this.topP = topP;
        this.stream = stream;
    }

    public static class ChatEntityBuilder {
        private String model;
        private List<MessageEntity> messages;
        private Double temperature;
        private Integer maxTokens;
        private Double topP;
        private boolean stream;

        public ChatEntityBuilder model(CompletionModel model) {
            if (ObjectUtils.isEmpty((Object)((Object)model))) {
                model = CompletionModel.GPT_35_TURBO;
            }
            switch (model) {
                case GPT_35_TURBO: 
                case GPT_35_TURBO_16K: 
                case GPT_35_TURBO_0613: 
                case GPT_35_TURBO_16K_0613: 
                case GPT_4: 
                case GPT_4_32K: 
                case GPT_4_0613: 
                case GPT_4_32K_0613: 
                case TEXT_DAVINCI_002: 
                case TEXT_DAVINCI_003: 
                case CODE_DAVINCI_002: {
                    this.model = model.getName();
                    break;
                }
                default: {
                    throw new ParamException(String.format("Not support completion model %s", new Object[]{model}));
                }
            }
            return this;
        }

        public ChatEntityBuilder temperature(Double temperature) {
            if (temperature < 0.0 || temperature > 2.0) {
                throw new ParamException(String.format("Invalid temperature: %s , between 0 and 2", temperature));
            }
            this.temperature = temperature;
            return this;
        }

        public ChatEntityBuilder maxTokens(Integer maxTokens) {
            CompletionModel completionModel = EnumsUtils.getCompleteModel(this.model);
            if (ObjectUtils.isNotEmpty((Object)this.model) && maxTokens > completionModel.getMaxTokens()) {
                throw new ParamException(String.format("Invalid maxTokens: %s, Cannot be larger than the model default configuration %s", maxTokens, completionModel.getMaxTokens()));
            }
            this.maxTokens = maxTokens;
            return this;
        }

        private ChatEntityBuilder stream() {
            return this;
        }

        public ChatEntity build() {
            return new ChatEntity(this);
        }

        ChatEntityBuilder() {
        }

        @JsonProperty(value="messages")
        public ChatEntityBuilder messages(List<MessageEntity> messages) {
            this.messages = messages;
            return this;
        }

        @JsonProperty(value="top_p")
        public ChatEntityBuilder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public String toString() {
            return "ChatEntity.ChatEntityBuilder(model=" + this.model + ", messages=" + this.messages + ", temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", topP=" + this.topP + ", stream=" + this.stream + ")";
        }
    }
}

