/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.model.AudioFormatModel;
import org.devlive.sdk.openai.model.AudioModel;
import org.devlive.sdk.openai.utils.FileUtils;
import org.devlive.sdk.openai.utils.MultipartBodyUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AudioEntity {
    @JsonProperty(value="file")
    private File file;
    @JsonProperty(value="model")
    private String model;
    @JsonProperty(value="prompt")
    private String prompt;
    @JsonProperty(value="response_format")
    private String format;
    @JsonProperty(value="temperature")
    private Double temperature;
    @JsonProperty(value="language")
    private String language;

    private AudioEntity(AudioEntityBuilder builder) {
        if (ObjectUtils.isEmpty((Object)builder.file)) {
            builder.file(null);
        }
        this.file = builder.file;
        if (ObjectUtils.isEmpty((Object)builder.model)) {
            builder.model("whisper-1");
        }
        this.model = builder.model;
        this.prompt = builder.prompt;
        if (StringUtils.isEmpty((CharSequence)builder.format)) {
            builder.format(AudioFormatModel.json.name());
        }
        this.format = builder.format;
        if (ObjectUtils.isEmpty((Object)builder.temperature)) {
            builder.temperature(1.0);
        }
        this.temperature = builder.temperature;
        this.language = builder.language;
    }

    public Map<String, RequestBody> convertMap() {
        ConcurrentMap map = Maps.newConcurrentMap();
        if (StringUtils.isNotEmpty((CharSequence)this.model)) {
            map.put("model", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getModel()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.prompt)) {
            map.put("prompt", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getPrompt()));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.format)) {
            map.put("response_format", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getFormat()));
        }
        if (ObjectUtils.isNotEmpty((Object)this.temperature)) {
            map.put("temperature", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)String.valueOf(this.getTemperature())));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.language)) {
            map.put("language", RequestBody.create((MediaType)MultipartBodyUtils.TYPE, (String)this.getLanguage()));
        }
        return map;
    }

    public static AudioEntityBuilder builder() {
        return new AudioEntityBuilder();
    }

    public File getFile() {
        return this.file;
    }

    public String getModel() {
        return this.model;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getFormat() {
        return this.format;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="file")
    public void setFile(File file) {
        this.file = file;
    }

    @JsonProperty(value="model")
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="prompt")
    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    @JsonProperty(value="response_format")
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="temperature")
    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    @JsonProperty(value="language")
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AudioEntity)) {
            return false;
        }
        AudioEntity other = (AudioEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$temperature = this.getTemperature();
        Double other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$format = this.getFormat();
        String other$format = other.getFormat();
        if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AudioEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    public String toString() {
        return "AudioEntity(file=" + this.getFile() + ", model=" + this.getModel() + ", prompt=" + this.getPrompt() + ", format=" + this.getFormat() + ", temperature=" + this.getTemperature() + ", language=" + this.getLanguage() + ")";
    }

    public AudioEntity() {
    }

    public AudioEntity(File file, String model, String prompt, String format, Double temperature, String language) {
        this.file = file;
        this.model = model;
        this.prompt = prompt;
        this.format = format;
        this.temperature = temperature;
        this.language = language;
    }

    public static class AudioEntityBuilder {
        private File file;
        private String model;
        private String prompt;
        private String format;
        private Double temperature;
        private String language;

        public AudioEntityBuilder file(File file) {
            if (ObjectUtils.isEmpty((Object)file)) {
                throw new ParamException("Invalid file must not be empty");
            }
            String extension = FileUtils.getExtension(file);
            if (StringUtils.isEmpty((CharSequence)extension) || ObjectUtils.isEmpty((Object)EnumUtils.getEnum(AudioModel.class, (String)extension.toLowerCase()))) {
                throw new ParamException(String.format("Invalid extension: %s , Must be one of %s", extension, Arrays.toString((Object[])AudioModel.values())));
            }
            this.file = file;
            return this;
        }

        public AudioEntityBuilder model(String model) {
            if (!model.equals("whisper-1")) {
                throw new ParamException(String.format("Invalid model: %s , Must be only support whisper-1", model));
            }
            this.model = model;
            return this;
        }

        public AudioEntityBuilder format(String format) {
            if (ObjectUtils.isEmpty((Object)EnumUtils.getEnum(AudioFormatModel.class, (String)format))) {
                throw new ParamException(String.format("Invalid format: %s , Must be one of %s", format, Arrays.toString((Object[])AudioFormatModel.values())));
            }
            this.format = format;
            return this;
        }

        public AudioEntityBuilder temperature(Double temperature) {
            if (temperature < 0.0 || temperature > 2.0) {
                throw new ParamException(String.format("Invalid temperature: %s , between 0 and 2", temperature));
            }
            this.temperature = temperature;
            return this;
        }

        public AudioEntity build() {
            return new AudioEntity(this);
        }

        AudioEntityBuilder() {
        }

        @JsonProperty(value="prompt")
        public AudioEntityBuilder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        @JsonProperty(value="language")
        public AudioEntityBuilder language(String language) {
            this.language = language;
            return this;
        }

        public String toString() {
            return "AudioEntity.AudioEntityBuilder(file=" + this.file + ", model=" + this.model + ", prompt=" + this.prompt + ", format=" + this.format + ", temperature=" + this.temperature + ", language=" + this.language + ")";
        }
    }
}

