/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.sse.EventSourceListener;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.devlive.sdk.openai.DefaultApi;
import org.devlive.sdk.openai.DefaultClient;
import org.devlive.sdk.openai.exception.ParamException;
import org.devlive.sdk.openai.interceptor.AzureInterceptor;
import org.devlive.sdk.openai.interceptor.ClaudeInterceptor;
import org.devlive.sdk.openai.interceptor.DefaultInterceptor;
import org.devlive.sdk.openai.interceptor.GooglePaLMInterceptor;
import org.devlive.sdk.openai.interceptor.OpenAiInterceptor;
import org.devlive.sdk.openai.model.CompletionModel;
import org.devlive.sdk.openai.model.ProviderModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class OpenAiClient
extends DefaultClient {
    private static final Logger log = LoggerFactory.getLogger(OpenAiClient.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private String apiKey;
    private String apiHost;
    private Integer timeout;
    private TimeUnit unit;
    private OkHttpClient client;
    private ProviderModel provider;
    private String model;
    private String version;
    private EventSourceListener listener;
    private String extra;

    private OpenAiClient(OpenAiClientBuilder builder) {
        boolean hasApiKey = StringUtils.isNotEmpty((CharSequence)builder.apiKey);
        if (!hasApiKey) {
            log.error("Invalid OpenAi token");
            throw new ParamException("Invalid OpenAi token");
        }
        if (ObjectUtils.isEmpty((Object)((Object)builder.provider))) {
            builder.provider(ProviderModel.OPENAI);
        }
        if (builder.provider.equals((Object)ProviderModel.AZURE)) {
            if (ObjectUtils.isEmpty((Object)builder.model)) {
                throw new ParamException("Azure provider model not specified");
            }
            if (ObjectUtils.isEmpty((Object)builder.version)) {
                throw new ParamException("Azure provider version not specified");
            }
        }
        if (ObjectUtils.isEmpty((Object)builder.apiHost)) {
            builder.apiHost(null);
        }
        if (ObjectUtils.isEmpty((Object)builder.timeout)) {
            builder.timeout(null);
        }
        if (ObjectUtils.isEmpty((Object)((Object)builder.unit))) {
            builder.unit(null);
        }
        if (ObjectUtils.isEmpty((Object)builder.client)) {
            builder.client(null);
        }
        if (ObjectUtils.isEmpty((Object)builder.listener)) {
            builder.listener(null);
        }
        ((DefaultClient)this).provider = builder.provider;
        ((DefaultClient)this).client = builder.client;
        ((DefaultClient)this).listener = builder.listener;
        ((DefaultClient)this).apiHost = builder.apiHost;
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.api = (DefaultApi)new Retrofit.Builder().baseUrl(builder.apiHost).client(builder.client).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).build().create(DefaultApi.class);
    }

    public static OpenAiClientBuilder builder() {
        return new OpenAiClientBuilder();
    }

    public static class OpenAiClientBuilder {
        private String apiKey;
        private String apiHost;
        private Integer timeout;
        private TimeUnit unit;
        private OkHttpClient client;
        private ProviderModel provider;
        private String model;
        private String version;
        private EventSourceListener listener;
        private String extra;

        public OpenAiClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public OpenAiClientBuilder apiHost(String apiHost) {
            if (StringUtils.isEmpty((CharSequence)apiHost)) {
                apiHost = this.getDefaultHost();
            } else {
                boolean flag;
                boolean bl = flag = apiHost.startsWith("http") || apiHost.startsWith("https");
                if (!flag) {
                    throw new ParamException(String.format("Invalid apiHost <%s> must start with http or https", apiHost));
                }
            }
            this.apiHost = apiHost;
            return this;
        }

        public OpenAiClientBuilder timeout(Integer timeout) {
            if (ObjectUtils.isEmpty((Object)timeout)) {
                timeout = 30;
            }
            this.timeout = timeout;
            return this;
        }

        public OpenAiClientBuilder unit(TimeUnit unit) {
            if (ObjectUtils.isEmpty((Object)((Object)unit))) {
                unit = TimeUnit.SECONDS;
            }
            this.unit = unit;
            return this;
        }

        public OpenAiClientBuilder client(OkHttpClient client) {
            if (ObjectUtils.isEmpty((Object)((Object)this.provider))) {
                this.provider = ProviderModel.OPENAI;
            }
            if (ObjectUtils.isEmpty((Object)client)) {
                log.debug("No client specified, creating default client");
                client = new OkHttpClient.Builder().connectTimeout((long)this.timeout.intValue(), this.unit).writeTimeout((long)this.timeout.intValue(), this.unit).readTimeout((long)this.timeout.intValue(), this.unit).callTimeout((long)this.timeout.intValue(), this.unit).build();
            }
            DefaultInterceptor interceptor = new OpenAiInterceptor();
            if (this.provider.equals((Object)ProviderModel.AZURE)) {
                interceptor = new AzureInterceptor();
                interceptor.setVersion(this.version);
                interceptor.setModel(this.model);
            }
            if (this.provider.equals((Object)ProviderModel.CLAUDE)) {
                interceptor = new ClaudeInterceptor();
            }
            if (this.provider.equals((Object)ProviderModel.GOOGLE_PALM)) {
                interceptor = new GooglePaLMInterceptor();
                interceptor.setApiKey(this.apiKey);
                interceptor.setModel(this.model);
            }
            interceptor.setApiKey(this.apiKey);
            interceptor.setExtra(this.extra);
            this.client = client = client.newBuilder().addInterceptor((Interceptor)interceptor).build();
            return this;
        }

        public OpenAiClientBuilder model(CompletionModel model) {
            this.model = model.getName();
            return this;
        }

        private String getDefaultHost() {
            if (ObjectUtils.isEmpty((Object)((Object)this.provider))) {
                this.provider = ProviderModel.OPENAI;
            }
            if (this.provider.equals((Object)ProviderModel.CLAUDE)) {
                return "https://api.anthropic.com";
            }
            if (this.provider.equals((Object)ProviderModel.GOOGLE_PALM)) {
                return "https://generativelanguage.googleapis.com";
            }
            return "https://api.openai.com";
        }

        public OpenAiClient build() {
            return new OpenAiClient(this);
        }

        OpenAiClientBuilder() {
        }

        public OpenAiClientBuilder provider(ProviderModel provider) {
            this.provider = provider;
            return this;
        }

        public OpenAiClientBuilder version(String version) {
            this.version = version;
            return this;
        }

        public OpenAiClientBuilder listener(EventSourceListener listener) {
            this.listener = listener;
            return this;
        }

        public OpenAiClientBuilder extra(String extra) {
            this.extra = extra;
            return this;
        }

        public String toString() {
            return "OpenAiClient.OpenAiClientBuilder(apiKey=" + this.apiKey + ", apiHost=" + this.apiHost + ", timeout=" + this.timeout + ", unit=" + (Object)((Object)this.unit) + ", client=" + this.client + ", provider=" + (Object)((Object)this.provider) + ", model=" + this.model + ", version=" + this.version + ", listener=" + this.listener + ", extra=" + this.extra + ")";
        }
    }
}

