/*
 * Decompiled with CFR 0.152.
 */
package org.devlive.sdk.openai;

import io.reactivex.Single;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.devlive.sdk.openai.entity.ChatEntity;
import org.devlive.sdk.openai.entity.CompletionEntity;
import org.devlive.sdk.openai.entity.EditEntity;
import org.devlive.sdk.openai.entity.EmbeddingEntity;
import org.devlive.sdk.openai.entity.FileEntity;
import org.devlive.sdk.openai.entity.FineTuningEntity;
import org.devlive.sdk.openai.entity.ImageEntity;
import org.devlive.sdk.openai.entity.ModelEntity;
import org.devlive.sdk.openai.entity.ModerationEntity;
import org.devlive.sdk.openai.entity.UserKeyEntity;
import org.devlive.sdk.openai.entity.beta.AssistantsEntity;
import org.devlive.sdk.openai.entity.beta.AssistantsFileEntity;
import org.devlive.sdk.openai.entity.beta.ThreadEntity;
import org.devlive.sdk.openai.response.AudioResponse;
import org.devlive.sdk.openai.response.ChatResponse;
import org.devlive.sdk.openai.response.CompleteResponse;
import org.devlive.sdk.openai.response.EditResponse;
import org.devlive.sdk.openai.response.EmbeddingResponse;
import org.devlive.sdk.openai.response.FileResponse;
import org.devlive.sdk.openai.response.FineTuningResponse;
import org.devlive.sdk.openai.response.ImageResponse;
import org.devlive.sdk.openai.response.ModelResponse;
import org.devlive.sdk.openai.response.ModerationResponse;
import org.devlive.sdk.openai.response.UserKeyResponse;
import org.devlive.sdk.openai.response.beta.AssistantsFileResponse;
import org.devlive.sdk.openai.response.beta.AssistantsResponse;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Url;

public interface DefaultApi {
    @GET
    public Single<ModelResponse> fetchModels(@Url String var1);

    @GET(value="v1/models/{model}")
    public Single<ModelEntity> fetchModel(@Path(value="model") String var1);

    @POST
    public Single<CompleteResponse> fetchCompletions(@Url String var1, @Body CompletionEntity var2);

    @POST
    public Single<CompleteResponse> fetchPaLMCompletions(@Url String var1, @Body org.devlive.sdk.openai.entity.google.CompletionEntity var2);

    @POST
    public Single<CompleteResponse> fetchPaLMChat(@Url String var1, @Body org.devlive.sdk.openai.entity.google.ChatEntity var2);

    @POST
    public Single<ChatResponse> fetchChatCompletions(@Url String var1, @Body ChatEntity var2);

    @GET(value="dashboard/user/api_keys")
    public Single<UserKeyResponse> fetchUserAPIKeys();

    @POST(value="dashboard/user/api_keys")
    public Single<UserKeyResponse> fetchCreateUserAPIKey(@Body UserKeyEntity var1);

    @POST
    public Single<ImageResponse> fetchImagesGenerations(@Url String var1, @Body ImageEntity var2);

    @POST
    @Multipart
    public Single<ImageResponse> fetchImagesEdits(@Url String var1, @Part MultipartBody.Part var2, @Part MultipartBody.Part var3, @PartMap Map<String, RequestBody> var4);

    @POST
    @Multipart
    public Single<ImageResponse> fetchImagesVariations(@Url String var1, @Part MultipartBody.Part var2, @PartMap Map<String, RequestBody> var3);

    @POST
    public Single<EmbeddingResponse> fetchEmbeddings(@Url String var1, @Body EmbeddingEntity var2);

    @POST
    @Multipart
    public Single<AudioResponse> fetchAudioTranscriptions(@Url String var1, @Part MultipartBody.Part var2, @PartMap Map<String, RequestBody> var3);

    @POST
    public Single<ModerationResponse> fetchModerations(@Url String var1, @Body ModerationEntity var2);

    @POST
    public Single<EditResponse> fetchEdits(@Url String var1, @Body EditEntity var2);

    @GET
    public Single<FileResponse> fetchFiles(@Url String var1);

    @POST
    @Multipart
    public Single<FileEntity> fetchUploadFile(@Url String var1, @Part MultipartBody.Part var2, @PartMap Map<String, RequestBody> var3);

    @DELETE
    public Single<FileResponse> fetchDeleteFile(@Url String var1);

    @GET
    public Single<FileEntity> fetchRetrieveFile(@Url String var1);

    @GET
    public Single<Object> fetchRetrieveFileContent(@Url String var1);

    @GET
    public Single<FineTuningResponse> fetchFineTuningJobs(@Url String var1);

    @POST
    public Single<FineTuningResponse> fetchCreateFineTuningJob(@Url String var1, @Body FineTuningEntity var2);

    @GET
    public Single<FineTuningResponse> fetchFineTuningJobEvents(@Url String var1);

    @GET
    public Single<FineTuningEntity> fetchFineTuningJobContent(@Url String var1);

    @POST
    public Single<FineTuningEntity> fetchCancelFineTuningJob(@Url String var1);

    @POST
    public Single<AssistantsEntity> fetchCreateAssistants(@Url String var1, @Body AssistantsEntity var2);

    @POST
    public Single<AssistantsFileEntity> fetchCreateAssistantFile(@Url String var1, @Body Map<String, String> var2);

    @GET
    public Single<AssistantsResponse> fetchAssistants(@Url String var1);

    @GET
    public Single<AssistantsFileResponse> fetchAssistantFiles(@Url String var1);

    @GET
    public Single<AssistantsEntity> fetchRetrieveAssistant(@Url String var1);

    @GET
    public Single<AssistantsFileEntity> fetchRetrieveAssistantFile(@Url String var1);

    @POST
    public Single<AssistantsEntity> fetchUpdateAssistant(@Url String var1, @Body AssistantsEntity var2);

    @DELETE
    public Single<AssistantsResponse> fetchDeleteAssistant(@Url String var1);

    @DELETE
    public Single<AssistantsFileResponse> fetchDeleteAssistantFile(@Url String var1);

    @POST
    public Single<ThreadEntity> fetchCreateThread(@Url String var1, @Body ThreadEntity var2);

    @GET
    public Single<ThreadEntity> fetchRetrieveThread(@Url String var1);

    @POST
    public Single<ThreadEntity> fetchUpdateThread(@Url String var1, @Body ThreadEntity var2);

    @DELETE
    public Single<ThreadEntity> fetchDeleteThread(@Url String var1);
}

